% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/origin_methods.r
\name{var_wtd_mean_cochran}
\alias{var_wtd_mean_cochran}
\title{Computes the variance of a weighted mean following the definition by Cochran (1977; see Gatz and Smith, 1995)}
\usage{
var_wtd_mean_cochran(x, w)
}
\arguments{
\item{x}{numeric vector of values}

\item{w}{numeric vector of weights}
}
\value{
numeric value of weighted variance
}
\description{
This is a helper method for weighted variance computation in \code{\link{origin_edm}}, which is the closest to the bootstrap.
}
\references{
\itemize{
  \item Gatz, D. F., and Smith, L. (1995). The standard error of a weighted mean concentration-I. Bootstrapping vs other methods. Atmospheric Environment, 29(11), 1185-1193. <DOI: 10.1016/1352-2310(94)00210-C>
  \item Gatz, D. F., and Smith, L. (1995). The standard error of a weighted mean concentration-II. Estimating confidence intervals. Atmospheric Environment, 29(11), 1195-1200. <DOI: 10.1016/1352-2310(94)00209-4>
  \item \url{https://r.789695.n4.nabble.com/Problem-with-Weighted-Variance-in-Hmisc-td826437.html}
}
}
