% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HessDotPlot.R
\name{HessDotPlot}
\alias{HessDotPlot}
\title{Second derivatives 3D scatter or surface plot against input values}
\usage{
HessDotPlot(
  object,
  fdata = NULL,
  input_vars = "all",
  input_vars2 = "all",
  output_vars = "all",
  surface = FALSE,
  grid = FALSE,
  color = NULL,
  ...
)
}
\arguments{
\item{object}{fitted neural network model or \code{array} containing the raw
second derivatives from the function \code{\link[NeuralSens]{HessianMLP}}}

\item{fdata}{\code{data.frame} containing the data to evaluate the second derivatives of the model.}

\item{input_vars}{\code{character vector} with the variables to create the scatter plot in x-axis. If \code{"all"},
then scatter plots are created for all the input variables in \code{fdata}.}

\item{input_vars2}{\code{character vector} with the variables to create the scatter plot in y-axis. If \code{"all"},
then scatter plots are created for all the input variables in \code{fdata}.}

\item{output_vars}{\code{character vector} with the variables to create the scatter plot. If \code{"all"},
then scatter plots are created for all the output variables in \code{fdata}.}

\item{surface}{\code{logical} if \code{TRUE}, a 3D surface is created instead of 3D scatter plot
(only for combinations of different inputs)}

\item{grid}{\code{logical}. If \code{TRUE}, plots created are show together using \code{\link[gridExtra]{arrangeGrob}}.
It does not work on Windows platforms due to bugs in \code{plotly} library.}

\item{color}{\code{character} specifying the name of a \code{numeric} variable of \code{fdata} to color the 3D scatter plot.}

\item{...}{further arguments that should be passed to  \code{\link[NeuralSens]{HessianMLP}} function}
}
\value{
list of 3D \code{geom_point} plots for the inputs variables representing the
sensitivity of each output respect to the inputs
}
\description{
3D Plot of second derivatives of the neural network output respect
to the inputs. This function use \code{plotly} instead of \code{ggplot2} to
achieve better visualization
}
\examples{
## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- DAILY_DEMAND_TR
## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 250
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,3] <- fdata.Reg.tr[,3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.tr, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.tr)

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                      data = nntrData,
                      linear.output = TRUE,
                      size = hidden_neurons,
                      decay = decay,
                      maxit = iters)
# Try HessDotPlot
NeuralSens::HessDotPlot(nnetmod, fdata = nntrData, surface = TRUE, color = "WD")
}
