% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HessMLP.R
\name{plot.HessMLP}
\alias{plot.HessMLP}
\title{Plot method for the HessMLP Class}
\usage{
\method{plot}{HessMLP}(
  x,
  plotType = c("sensitivities", "time", "features", "matrix", "interactions"),
  ...
)
}
\arguments{
\item{x}{\code{HessMLP} object created by \code{\link[NeuralSens]{HessianMLP}}}

\item{plotType}{\code{character} specifying which type of plot should be created. It can be:
\itemize{
     \item "sensitivities" (default): use \code{\link[NeuralSens]{HessianMLP}} function
     \item "time": use \code{\link[NeuralSens]{SensTimePlot}} function
     \item "features": use  \code{\link[NeuralSens]{HessFeaturePlot}} function
     \item "matrix": use \code{\link[NeuralSens]{SensMatPlot}} function to show the values
     of second partial derivatives
     \item "interactions": use \code{\link[NeuralSens]{SensMatPlot}} function to show the
     values of second partial derivatives and the first partial derivatives in the diagonal
     }}

\item{...}{additional parameters passed to plot function of the \code{NeuralSens} package}
}
\value{
list of graphic objects created by \code{\link[ggplot2]{ggplot}}
}
\description{
Plot the sensitivities and sensitivity metrics of a \code{HessMLP} object.
}
\examples{
#' ## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- DAILY_DEMAND_TR

## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 250
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,3] <- fdata.Reg.tr[,3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.tr, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.tr)

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                           data = nntrData,
                           linear.output = TRUE,
                           size = hidden_neurons,
                           decay = decay,
                           maxit = iters)
# Try HessianMLP
sens <- NeuralSens::HessianMLP(nnetmod, trData = nntrData, plot = FALSE)
\donttest{
plot(sens)
plot(sens,"time")
}
}
