% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{add_clusters}
\alias{add_clusters}
\title{add_clusters}
\usage{
add_clusters(corpus, clust)
}
\arguments{
\item{corpus}{A \code{Corpus} object.}

\item{clust}{A \code{\link[FactoMineR:HCPC]{HCPC}} object resulting from
a call to \code{\link{corpus_clustering}}.}
}
\value{
A \code{Corpus} object with \code{meta(corpus, "cluster")} indicating the cluster
of each document.
}
\description{
Add a meta-data variable to a corpus indicating the cluster
to which each document belongs.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
res <- corpus_ca(corpus, dtm, ncp=2, sparsity=0.98)
clust <- corpus_clustering(res, 3)
corpus <- add_clusters(corpus, clust)
meta(corpus)

}
