% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_rlogic.R
\name{rd_rlogic}
\alias{rd_rlogic}
\title{REDCap logic into R logic}
\usage{
rd_rlogic(..., data = NULL, dic = NULL, event_form = NULL, logic, var)
}
\arguments{
\item{...}{List containing the data and the dictionary and the event if it's needed. Can be the output of the function `redcap_data`.}

\item{data}{Data frame containing data from REDCap. If the list is specified this argument is not needed.}

\item{dic}{Data frame  containing the dictionary read from REDCap. If the list is specified this argument is not needed.}

\item{event_form}{Data frame  containing the correspondence of each event with each form. If the list is specified this argument is not needed.}

\item{logic}{String containing a logic in REDCap format.}

\item{var}{string containing the name of the variable that contains the logic.}
}
\value{
List containing the logic in R format and its evaluation.
}
\description{
This function allows you to transcribe REDCap logic to R logic. WARNING: If the REDCap logic involves some smart-variables this function will not be able to transform it.
}
\examples{
rd_rlogic(covican,
          logic = "if([exc_1]='1' or [inc_1]='0' or [inc_2]='0' or [inc_3]='0',1,0)",
          var = "screening_fail_crit")
}
