/*
 * Decompiled with CFR 0.152.
 */
package freak.gui;

import freak.core.control.EventController;
import freak.core.control.EventInfo;
import freak.core.event.EventSource;
import freak.core.modulesupport.Module;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class EventTable
extends JTable {
    private Module module;
    private EventController eventController;
    private ArrayList eventComboBoxes = new ArrayList();
    private List events;
    private Object[] eventSources;
    private EventTableCellRenderer tableRenderer = new EventTableCellRenderer();

    public EventTable(Module module, EventController eventController, Object[] eventSources) {
        if (module == null || eventController == null) {
            throw new NullPointerException("EventPanel: constructor got null as parameter.");
        }
        this.module = module;
        this.eventController = eventController;
        this.eventSources = eventSources;
        this.events = eventController.getCustomizableEventsFor(module);
        this.buildComboBoxes();
        if (this.events.size() != this.eventComboBoxes.size()) {
            throw new RuntimeException("EventTable: size of events is != size of comboBoxes.");
        }
        DefaultTableModel tm = new DefaultTableModel(null, new Object[]{"Event", "recieving from"});
        int i = 0;
        while (i < this.events.size()) {
            tm.addRow(new Object[]{((EventInfo)this.events.get(i)).getEventName(), ""});
            ++i;
        }
        this.setModel(tm);
        this.setRowHeight(20);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 1) {
            return new DefaultCellEditor((JComboBox)this.eventComboBoxes.get(row));
        }
        return null;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 1) {
            return this.tableRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    private void buildComboBoxes() {
        this.eventComboBoxes.clear();
        int i = 0;
        while (i < this.events.size()) {
            EventInfo evt = (EventInfo)this.events.get(i);
            JComboBox<EventSourceWrapper> cb = new JComboBox<EventSourceWrapper>();
            this.eventComboBoxes.add(cb);
            boolean foundSelection = false;
            int j = 0;
            while (j < this.eventSources.length) {
                Class eventSourceType = EventController.getEventSourceClassFor(evt.getEventType());
                if (eventSourceType.isAssignableFrom(this.eventSources[j].getClass())) {
                    EventSourceWrapper eo = new EventSourceWrapper(this.eventSources[j]);
                    cb.addItem(eo);
                    if (!foundSelection && this.eventSources[j].equals(evt.getEventSource())) {
                        cb.setSelectedItem(eo);
                        foundSelection = true;
                    }
                }
                ++j;
            }
            if (!foundSelection) {
                cb.setSelectedIndex(-1);
            }
            cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EventTable.this.eventSourceChanged(EventTable.this.eventComboBoxes.indexOf(e.getSource()));
                }
            });
            ++i;
        }
    }

    private void eventSourceChanged(int comboBoxIndex) {
        EventInfo evt = (EventInfo)this.events.get(comboBoxIndex);
        JComboBox cb = (JComboBox)this.eventComboBoxes.get(comboBoxIndex);
        EventSourceWrapper eo = (EventSourceWrapper)cb.getSelectedItem();
        if (eo != null) {
            evt.setEventSource((EventSource)eo.getObject());
        } else {
            evt.setEventSource(null);
        }
    }

    private class EventSourceWrapper {
        private Object obj;

        public EventSourceWrapper(Object o) {
            this.obj = o;
        }

        public String toString() {
            if (this.obj instanceof Module) {
                return ((Module)this.obj).getName();
            }
            return this.obj.toString();
        }

        public Object getObject() {
            return this.obj;
        }
    }

    private class EventTableCellRenderer
    implements TableCellRenderer {
        private EventTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 1) {
                return (Component)EventTable.this.eventComboBoxes.get(row);
            }
            return null;
        }
    }
}

