/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset.math.matrix.view;

import freak.module.fitness.pointset.math.matrix.Matrix;
import freak.module.fitness.pointset.math.matrix.view.ExtendedView;
import freak.module.fitness.pointset.math.matrix.view.NormalView;
import freak.module.fitness.pointset.math.matrix.view.SimpleView;

public class MatrixSimpleOperation
extends ExtendedView {
    public MatrixSimpleOperation(Matrix m) {
        super(new NormalView(m));
    }

    public MatrixSimpleOperation(ExtendedView pView) {
        super(pView.view);
    }

    public MatrixSimpleOperation(SimpleView pView) {
        super(pView);
    }

    public NormalView multMatrix(SimpleView pOther) {
        if (this.view.getCol() != pOther.getRow()) {
            throw new Error("Bad dimensions in multMatrix");
        }
        Matrix newMat = new Matrix(this.view.getRow(), pOther.getCol());
        NormalView nvNewMat = new NormalView(newMat);
        int r = 0;
        while (r < nvNewMat.getRow()) {
            int c = 0;
            while (c < nvNewMat.getCol()) {
                double temp_scalar = 0.0;
                try {
                    int k = 0;
                    while (k < this.view.getCol()) {
                        temp_scalar += this.view.get(r, k) * pOther.get(k, c);
                        ++k;
                    }
                    nvNewMat.set(r, c, temp_scalar);
                }
                catch (Exception e) {
                    throw new Error("Unsupported Error in multMatrix");
                }
                ++c;
            }
            ++r;
        }
        return nvNewMat;
    }

    public NormalView multMatrix(ExtendedView pOther) {
        return this.multMatrix(pOther.view);
    }

    public void addMatrix(SimpleView pOther) throws Exception {
        if (this.view.getCol() != pOther.getCol() || this.view.getRow() != pOther.getRow()) {
            throw new Exception("Die Spalten oder Zeilen zahlen stimmen nicht ueberein");
        }
        if (this.view.sameModel(pOther)) {
            int c;
            double[][] m = new double[this.view.getRow()][this.view.getCol()];
            int r = 0;
            while (r < this.view.getRow()) {
                c = 0;
                while (c < this.view.getCol()) {
                    m[r][c] = this.view.get(r, c) + pOther.get(r, c);
                    ++c;
                }
                ++r;
            }
            r = 0;
            while (r < this.view.getRow()) {
                c = 0;
                while (c < this.view.getCol()) {
                    this.view.set(r, c, m[r][c]);
                    ++c;
                }
                ++r;
            }
        } else {
            int r = 0;
            while (r < this.view.getRow()) {
                int c = 0;
                while (c < this.view.getCol()) {
                    this.view.set(r, c, this.view.get(r, c) + pOther.get(r, c));
                    ++c;
                }
                ++r;
            }
        }
    }

    public void addMatrix(ExtendedView pOther) throws Exception {
        this.addMatrix(pOther.view);
    }

    public Matrix addMatrixM(SimpleView pOther) throws Exception {
        if (this.view.getCol() != pOther.getCol() || this.view.getRow() != pOther.getRow()) {
            throw new Exception("Die Spalten oder Zeilen zahlen stimmen nicht ueberein");
        }
        Matrix m = this.view.copyModelFromView();
        MatrixSimpleOperation sop = new MatrixSimpleOperation(m);
        sop.addMatrix(pOther);
        return m;
    }

    public Matrix addMatrixM(ExtendedView pOther) throws Exception {
        return this.addMatrixM(pOther.view);
    }

    public MatrixSimpleOperation addMatrixMV(SimpleView pOther) throws Exception {
        return new MatrixSimpleOperation(new NormalView(this.addMatrixM(pOther)));
    }

    public MatrixSimpleOperation addMatrixMV(ExtendedView pOther) throws Exception {
        return this.addMatrixMV(pOther.view);
    }

    public void swapRows(int rowIndex1, int rowIndex2) throws Exception {
        if (!this.view.validRowIndex(rowIndex1) || !this.view.validRowIndex(rowIndex2)) {
            throw new Exception("Bad rowIndex");
        }
        int c = 0;
        while (c < this.view.getCol()) {
            double temp = this.view.get(rowIndex1, c);
            this.view.set(rowIndex1, c, this.view.get(rowIndex2, c));
            this.view.set(rowIndex2, c, temp);
            ++c;
        }
    }

    public void swapCols(int colIndex1, int colIndex2) throws Exception {
        if (!this.view.validColIndex(colIndex1) || !this.view.validColIndex(colIndex2)) {
            throw new Exception("Bad colIndex");
        }
        int r = 0;
        while (r < this.view.getRow()) {
            double temp = this.view.get(r, colIndex1);
            this.view.set(r, colIndex1, this.view.get(r, colIndex2));
            this.view.set(r, colIndex2, temp);
            ++r;
        }
    }
}

