/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.GenerationEvent;
import freak.core.fitness.MultiObjectiveFitnessFunction;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.core.stoppingcriterion.AbstractGenerationStoppingCriterion;

public class ParetoFrontFound
extends AbstractGenerationStoppingCriterion {
    public ParetoFrontFound(Schedule schedule) {
        super(schedule);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof MultiObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on multi objective fitness functions only.");
        }
        try {
            ((MultiObjectiveFitnessFunction)this.getSchedule().getFitnessFunction()).containsParetoFront(new Population(schedule));
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedEnvironmentException("The stopping criterion can't be applied to the chosen fitness function\n since the pareto front is unknown.");
        }
    }

    protected void checkCriterion(GenerationEvent evt) {
        IndividualList p = this.getSchedule().getPopulationManager().getPopulation();
        MultiObjectiveFitnessFunction ff = (MultiObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
        if (ff.containsParetoFront(p)) {
            this.stopRun();
        }
    }

    public String getName() {
        return "Pareto Front Found";
    }

    public String getDescription() {
        return "Stopps the algorithm when a representation of the pareto front is contained in the current population.";
    }
}

