% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OINT.R
\name{OINT}
\alias{OINT}
\title{Omnibus-INT}
\usage{
OINT(y, G, X = NULL, k = 3/8, simple = FALSE, parallel = FALSE)
}
\arguments{
\item{y}{Numeric phenotype vector.}

\item{G}{Obs by locus genotype matrix.}

\item{X}{Model matrix of covariates and structure adjustments. Should include
an intercept. Omit to perform marginal tests of association.}

\item{k}{Offset applied during rank-normalization. See 
\code{\link{rankNorm}}.}

\item{simple}{Return the OINT p-values only?}

\item{parallel}{Logical indicating whether to run in parallel. Must register 
parallel backend first.}
}
\value{
A numeric matrix of p-values, three for each column of \code{G}.
}
\description{
Association test that synthesizes the \code{\link{DINT}} and
\code{\link{IINT}} tests. The first approach is most powerful for traits that
could have arisen from a rank-preserving transformation of a latent normal
trait. The second approach is most powerful for traits that are linear in
covariates, yet have skewed or kurtotic residual distributions. During the
omnibus test, the direct and indirect tests are separately applied then
}
\examples{
\dontrun{
set.seed(100);
# Design matrix
X = cbind(1,rnorm(1e3));
# Genotypes
G = replicate(1e3,rbinom(n=1e3,size=2,prob=0.25));
storage.mode(G) = "numeric";
# Phenotype
y = exp(as.numeric(X\%*\%c(1,1))+rnorm(1e3));
# Omnibus
p = OINT(y=y,G=G,X=X,simple=T);
}
}
\seealso{
Basic association test \code{\link{BAT}}, direct INT \code{\link{DINT}}, 
indirect INT \code{\link{IINT}}.
}
