% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res_sk_map.R
\name{res_sk_map}
\alias{res_sk_map}
\title{Local Reserve Map With Seasonal Kendall Results}
\usage{
res_sk_map(
  nerr_site_id,
  stations,
  sk_result = NULL,
  bbox,
  shp,
  station_labs = TRUE,
  lab_loc = NULL,
  zoom = NULL,
  maptype = "stamen-toner"
)
}
\arguments{
\item{nerr_site_id}{chr string of the reserve to make, first three characters used by NERRS}

\item{stations}{chr string of the reserve stations to include in the map}

\item{sk_result}{vector of values denoting direction and significance of seasonal kendall results. Result should be \code{c('inc', 'dec', 'insig', 'insuff')} for significant positive, significant negative, no significant results, and insufficient data to calculate result.}

\item{bbox}{a bounding box associated with the reserve. Must be in the format of c(X1, Y1, X2, Y2)}

\item{shp}{{sf} data frame (preferred) or SpatialPolygons object}

\item{station_labs}{logical, should stations be labeled? Defaults to \code{TRUE}}

\item{lab_loc}{chr vector of 'R' and 'L', one letter for each station. if no \code{lab_loc} is specified then labels will default to the left.}

\item{zoom}{zoom level, 1-21 for OpenStreetMaps maps. Default is to autoscale based on bbox. Higher numbers give more detail.}

\item{maptype}{stamen map type from OpenStreetMap::openmap. Theoretically one of c("osm", "osm-bw","maptoolkit-topo", "waze", "bing", "stamen-toner", "stamen-terrain", "stamen-watercolor", "osm-german", "osm-wanderreitkarte", "mapbox", "esri", "esri-topo", "nps", "apple-iphoto", "skobbler", "hillshade", "opencyclemap", "osm-transport", "osm-public-transport", "osm-bbike", "osm-bbike-german").  However, many of these may not work. "stamen-toner", "stamen-terrain", and "bing" seem to work well.}
}
\value{
returns a {ggplot} object.
}
\description{
Create a stylized reserve-level map of seasonal kendall results for use with the reserve level reporting template
}
\details{
Creates a stylized, reserve-level base map for displaying seasonal kendall results from \code{\link{sk_seasonal}}. The user can specify the reserve and stations to plot. The user can also specify a bounding box. For multi-component reserves, the user should specify a bounding box that highlights the component of interest.

To display seasonal trends, the user must specify \code{c('inc', 'dec', 'insig', 'insuff')} for each station listed in the \code{stations} argument.
}
\examples{
## A compact reserve

### set plotting parameters
stations <- sampling_stations[(sampling_stations$NERR.Site.ID == 'elk'
     & sampling_stations$Status == 'Active'
     & sampling_stations$isSWMP == "P"), ]$Station.Code
     to_match <- c('wq')
stns <- stations[grep(paste(to_match, collapse = '|'), stations)]
shp_fl <- elk_spatial
bounding_elk <- c(-121.810978, 36.868218, -121.708667, 36.764050)
trnds <- c('inc', 'dec', 'insuff', 'insig')

### Low zoom and default maptype plot (for CRAN testing, not recommended)
#    Lower zoom number gives coarser text and fewer features
x_low <- res_sk_map('elk', stations = stns, sk_result = trnds,
                 bbox = bounding_elk, shp = shp_fl,
                 zoom = 10)

\donttest{

### Default zoom and maptype
x_def <- res_sk_map('elk', stations = stns, sk_result = trnds,
                 bbox = bounding_elk, shp = shp_fl)

### Higher zoom number gives more details, but those may not be visible
x_14 <- res_sk_map('elk', stations = stns, sk_result = trnds,
                 bbox = bounding_elk, shp = shp_fl,
                 zoom = 14)

### Different maptypes may be used.  All may not be available.
#    Note that zoom and maptype interact, so some experimentation may be
#    required.
x_terrain <- res_sk_map('elk', stations = stns, sk_result = trnds,
                 bbox = bounding_elk, shp = shp_fl,
                 maptype = 'stamen-terrain')
### A multicomponent reserve (showing two different bounding boxes)

#  set plotting parameters
stations <- sampling_stations[(sampling_stations$NERR.Site.ID == 'cbm'
         & sampling_stations$Status == 'Active'
         & sampling_stations$isSWMP == "P"), ]$Station.Code
         to_match <- c('wq')
stns <- stations[grep(paste(to_match, collapse = '|'), stations)]
shp_fl <- cbm_spatial
bounding_cbm_1 <- c(-77.393, 39.741, -75.553, 38.277)
bounding_cbm_2 <- c(-76.8,  38.7, -76.62,  38.85)
trnds <- c('inc', 'insuff', 'dec', 'insig')

#   plot
y <- res_sk_map('cbm', stations = stns, sk_result = trnds,
                 bbox = bounding_cbm_1, shp = shp_fl)

z <- res_sk_map('cbm', stations = stns, sk_result = trnds,
                 bbox = bounding_cbm_2, shp = shp_fl)
}
}
\author{
Julie Padilla, Dave Eslinger
}
\concept{analyze}
