% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatosttwoprop.h.R
\name{datatosttwoprop}
\alias{datatosttwoprop}
\title{TOST Two Proportions}
\usage{
datatosttwoprop(
  data,
  var,
  level,
  group,
  hypothesis = "EQU",
  low_eqbound = -0.1,
  high_eqbound = 0.1,
  alpha = 0.05,
  desc = FALSE,
  plot = FALSE
)
}
\arguments{
\item{data}{.}

\item{var}{.}

\item{level}{.}

\item{group}{.}

\item{hypothesis}{\code{'EQU'} for equivalence (default), or \code{'MET'}
for minimal effects test, the alternative hypothesis.}

\item{low_eqbound}{a number (default: -0.1) the lower equivalence bounds}

\item{high_eqbound}{a number (default: 0.1) the upper equivalence bounds}

\item{alpha}{alpha level (default = 0.05)}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive
statistics}

\item{plot}{\code{TRUE} or \code{FALSE} (default), provide plot}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$tost} \tab \tab \tab \tab \tab a table \cr
  \code{results$eqb} \tab \tab \tab \tab \tab a table \cr
  \code{results$desc} \tab \tab \tab \tab \tab a table \cr
  \code{results$plot} \tab \tab \tab \tab \tab an image \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$tost$asDF}

\code{as.data.frame(results$tost)}
}
\description{
TOST Two Proportions
}
