\name{constructplant}
\alias{constructplant}
\alias{readplantlist}
\title{
Construct a 3D plant
}
\description{
Read in legacy-style Yplant input files into a special object, to be used in any analysis in YplantQMC. 

The function constructs an object of class \code{plant3d}, based on Yplant input files (.p and .l/.lf). Various
methods exist for \code{plant3d} objects, in particular \code{\link{plot.plant3d}} and 
\code{\link{summary.plant3d}}. 

For batch analyses, the function \code{readplantlist} reads a number of files at a time, and stores the results in 
a special list (of class \code{plant3dlist}).

Three plants are provided with \code{YplantQMC} (and automatically loaded) :\code{toona},
\code{pilularis} and \code{sugarmaple}. See \code{\link{plantexamples}}.

To learn about the format of P and L files, read the detailed account on the Prometheus wiki (Pearcy, Falster & Duursma 2011): \url{http://goo.gl/Hmyv6}.

}
\usage{
constructplant(pfile = NULL, lfile = NULL, qfile = NULL, multiplier=1.0, 
X0 = 0, Y0 = 0, Z0 = 0, warn=FALSE, quiet=FALSE)
readplantlist(pfiles=NA, lfiles=NA, lpk="leafplantkey.txt", multiplier=1)
}
\arguments{
  \item{pfile,lfile}{Name of .p and .l (or .lf) file.}
  \item{qfile}{Optionally, instead of a pfile, a Q file format. See Details.}
  \item{multiplier}{Multiplies length dimensions, e.g. to change units.}
  \item{X0,Y0,Z0}{New x,y,z coordinate of the stem base.}
  \item{warn}{If TRUE, writes warnings of minor issues with P file format.}
  \item{quiet}{If TRUE, no messages are ever shown.}
  \item{pfiles,lfiles}{Vectors of .p files and .l files.}
  \item{lpk}{Optionally, a 'leafplantkey' file. See Details.}
}
\details{
For legacy Yplant users (Pearcy and Yang 1996, see \url{http://goo.gl/Hmyv6}), you will find that \code{constructplant} is much more robust with respect to malformed input files. It will also attempt to write error messages when things go wrong.

The \bold{Q file} format is an alternative to .P files, and is much easier to use if the virtual plant does not have stem sections. There are seven columns: 

\describe{
\item{X,Y,Z}{ Coordinates of the leaf base}
\item{ang,az}{ Angle and azimuth of the normal to the leaf surface}
\item{or}{Orientation (azimuth angle) of the midrib}
\item{L}{Leaf length}
}

The file is space-delimited (such as the output of \code{write.table}), and includes column headers (exactly named as above).

The \bold{leafplantkey} file is a convenient way to organize a large number of plant files. This is a simple 
comma-separated text file without headers. The order is pfile,lfile (without quotes). For example, a "leafplantkey.txt"
file may look like this:
\preformatted{
acaflo1.p,acaflo.l
acaflo2.p,acaflo.l
acaflo3.p,acaflo.l
acamyr1.p,acamyr.l
acamyr2.p,acamyr.l
acamyr3.p,acamyr.l
acasua1.p,acasua.l
acasua2.p,acasua.l
acasua4.p,acasua.l
acasuaR02.p,acasua.l
acasuaR05.p,acasua.l
acasuaR09.p,acasua.l
}


}
\value{
In the case of \code{constructplant}, an object of class \code{plant3d}. For \code{readplantlist},
an object of class \code{plant3dlist} (which is simply a list of objects as generated by \code{constructplant} 
to ease batch analyses).
}
\author{
Remko Duursma
}
\seealso{
\code{\link{plot.plant3d},\link{readp}}
}
\examples{

\dontrun{
# Read one plant:
myplant <- constructplant("sompfile.p","somelfile.l")

# Pfile was in cm - should be in mm. Multiply all length dimensions by 10.
myplant <- constructplant("sompfile.p","somelfile.l", multiplier=10)

# Read a couple of plants. 
myplants <- constructplant(pfiles=c("plant1.p","plant2.p"), lfiles=rep("leaf.l",2))

}





}
\keyword{misc}