% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Equidigital.R
\name{Equidigital}
\alias{Equidigital}
\alias{A046758}
\title{Equidigital numbers}
\usage{
Equidigital(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A046758}{A046758}, an \emph{Equidigital} number has equal digits
than the number of digits in its prime factorization including exponents. First 6 Equidigital numbers are 1, 2, 3, 5, 7, 10. Though
it doesn't matter which base we use, here we adopt only a base of 10.
}
\examples{
## generate first 20 Equidigital numbers
first20 = Equidigital(20)

## print without trailing 0's.
print(first20, drop0trailing = TRUE)

}
\seealso{
\code{\link{Frugal}}, \code{\link{Extravagant}}
}
