% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsim_met.R
\name{read_apsim_met}
\alias{read_apsim_met}
\title{Read in an APSIM met file}
\usage{
read_apsim_met(file, src.dir = ".", verbose = TRUE)
}
\arguments{
\item{file}{path to met file}

\item{src.dir}{optional source directory}

\item{verbose}{whether to suppress all messages and warnings}
}
\value{
an object of class \sQuote{met} with attributes
}
\description{
Read into R a met file and return an object of class \sQuote{met}
}
\details{
Read a met file into R

This function uses S3 classes and stores the additional information as attributes \cr
I use a more strict format than \acronym{APSIM} and reading and writing will not \cr
preserve all the details. For example, at this moment comments are lost through \cr
the process of read and write unless they are added back in manually. \cr
Also, empty lines are ignored so these will be lost as well in the read and write process.
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "apsimx")
ames.met <- read_apsim_met("Ames.met", src.dir = extd.dir)
ames.met
}

}
