% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_apsim.R
\name{optim_apsim}
\alias{optim_apsim}
\alias{print.optim_apsim}
\alias{vcov.optim_apsim}
\alias{coef.optim_apsim}
\title{Optimize parameters in an APSIM simulation}
\usage{
optim_apsim(
  file,
  src.dir = ".",
  crop.file,
  parm.paths,
  data,
  type = c("optim", "nloptr", "mcmc"),
  weights,
  index = "Date",
  parm.vector.index,
  xml.parm,
  ...
)

\method{print}{optim_apsim}(x, ..., digits = 3, level = 0.95)

\method{vcov}{optim_apsim}(object, ..., scaled = TRUE)

\method{coef}{optim_apsim}(object, ..., scaled = FALSE)
}
\arguments{
\item{file}{file name to be run (the extension .apsim is optional)}

\item{src.dir}{directory containing the .apsim file to be run (defaults to the current directory)}

\item{crop.file}{name of auxiliary xml file where parameters are stored. If this is missing, it is 
assumed that the parameters to be edited are in the main simulation file.}

\item{parm.paths}{absolute paths of the coefficients to be optimized. 
It is recommended that you use \code{\link{inspect_apsim}} or \code{\link{inspect_apsim_xml}}  for this.}

\item{data}{data frame with the observed data. By default is assumes there is a 'Date' column for the index.}

\item{type}{Type of optimization. For now, \code{\link[stats]{optim}} and, if available, \code{\link[nloptr]{nloptr}} or \sQuote{mcmc} through \code{\link[BayesianTools]{runMCMC}}.}

\item{weights}{Weighting method or values for computing the residual sum of squares (see Note).}

\item{index}{Index for filtering APSIM output. \sQuote{Date} is currently used. (I have not tested how well it works using anything other than Date).}

\item{parm.vector.index}{Index to optimize a specific element of a parameter vector. At the moment it is
possible to only edit one element at a time. This is because there is a conflict when generating multiple
elements in the candidate vector for the same parameter.}

\item{xml.parm}{optional logical vector used when optimizing parameters which are both in the .apsim file and in the \sQuote{crop.file}.
If \sQuote{crop.file} is missing it is assumed that the paramters to be optimized are in the .apsim file. If \sQuote{crop.file} is
not missing it is assumed that they are in the \sQuote{crop.file}. If the parameters are in both, this needs to be specified in 
this argument.}

\item{...}{additional arguments (none used at the moment)}

\item{x}{object of class \sQuote{optim_apsim}}

\item{digits}{number of digits to round up the output}

\item{level}{confidence level (default 0.95)}

\item{object}{object of class \sQuote{optim_apsim}}

\item{scaled}{whether to return the scaled or unscaled estimates
(TRUE in the optimized scale, FALSE in the original scale)}
}
\value{
object of class \sQuote{optim_apsim}, but really just a list with results from optim and additional information.

prints to console

it returns the variance-covariance matrix for an object of class \sQuote{optim_apsim}.

a numeric vector with the value of the parameter estimates.
}
\description{
It is a wrapper for running APSIM and optimizing parameters using \code{\link[stats]{optim}}

Friendly printing of optim_apsim

Variance-Covariance for an \sQuote{optim_apsim} object

Parameter estimates for an \sQuote{optim_apsim} object
}
\details{
Simple optimization for APSIM Classic

* This function assumes that you want to optimize parameters which are stored in
an auxiliary XML file. These are typically crop or cultivar specific parameters.
However, it is possible to optimize parameters present in the main simulation
file.

* Only one observation per day is allowed in the data.

* Given how APSIM Classic works, this can only be run when the main simulation
file is in the current directory and the crop file (or XML) 
should be in the same directory as the main simulation.

* The initial values for the optimization should be the ones in the stored
crop parameter file.

* It is suggested that you keep a backup of the original file. This function
will edit and overwrite the file during the optimization. 

* When you use the parm.vector.index you cannot edit two separate elements of
a vector at the same time. This should be used to target a single element of 
a vector only.

* Internally, the optimization is done around the scaled value of the initial parameter
values. A value of 1 would correspond to the inital value of the parameter. 
The \sQuote{lower} and \sQuote{upper} (or \sQuote{ub} and \sQuote{lb}) are also scaled 
to the initial values of the parameters. So, for example, if your initial value is 20 
and you provide an upper bound of 5, it means that the actual upper value that you are allowing for is 100.
}
\note{
When computing the objective function (residual sum-of-squares) different variables are combined.
It is common to weight them since they are in different units. If the argument weights is not supplied
no weighting is applied. It can be \sQuote{mean}, \sQuote{var} or a numeric vector of appropriate length.

This in the scale of the optimized parameters which are
scaled to be around 1.
}
