% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsim_soils.R
\name{read_apsim_soils}
\alias{read_apsim_soils}
\title{Read in a soils (XML) file into a list of \sQuote{soil_profile} objects}
\usage{
read_apsim_soils(file, src.dir = ".", verbose = TRUE)
}
\arguments{
\item{file}{name of the file (the extension sohuld be .soils)}

\item{src.dir}{directory containing the .soils file (defaults to the current directory)}

\item{verbose}{whether to print additional information about the progress of reading 
the individual soils in.}
}
\description{
APSIM soils can be stored as XML files (soils) and reading them in
converts them into a list of individual objects of class \sQuote{soil_profile}
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "apsimx")

sls <- read_apsim_soils("Clarion.soils", src.dir = extd.dir)

}
}
