% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{alcdf}
\alias{alcdf}
\title{Asymmetric Laplace Distribution}
\usage{
alcdf(x, mu, sigma, p)
}
\arguments{
\item{x}{scalar value.}

\item{mu}{location parameter of ALD.}

\item{sigma}{scale parameter of ALD.}

\item{p}{quantile or skewness parameter, p in (0,1).}
}
\value{
Returns a scalar with cumulative probability value at
point 'x'.
}
\description{
This function computes the cumulative distribution (CDF) for
an asymmetric Laplace distribution.
}
\details{
Computes the cumulative distribution function for
the asymmetric Laplace distribution.
\deqn{CDF(x) = F(x) = P(X \le x)} where X is a
random variable
}
\examples{
set.seed(101)
x <- -0.5428573
mu <- 0.5
sigma <- 1
p <- 0.25
ans <- alcdf(x, mu, sigma, p)

# ans
#   0.1143562

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

 Koenker, R. and Machado, J. (1999). “Goodness  of  Fit  and  Related
 Inference  Processes  for  Quantile Regression.”
 Journal of American Statistics Association, 94(3): 1296-1309.

 Keming, Y. and Zhang, J. (2005). “A Three-Parameter Asymmetric
 Laplace Distribution.” Communications in Statistics - Theory and Methods, 34(9):
 1867-1879.
}
\seealso{
cumulative distribution function, asymmetric Laplace distribution
}
