% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kgroups_surv.R
\name{kgroups_surv}
\alias{kgroups_surv}
\title{k-groups of survival curves}
\usage{
kgroups_surv(time, status, fac, k, kbin = 50, algorithm = "kmeans",
  seed = NULL)
}
\arguments{
\item{time}{Survival time.}

\item{status}{Censoring indicator of the survival time of the process; 0 if
the total time is censored and 1 otherwise.}

\item{fac}{Categoriacl variable indicating the population to which
the subject belongs}

\item{k}{An integer specifying the number of groups of curves to be
performed.}

\item{kbin}{Size of the grid over which the survival functions
are to be estimated.}

\item{algorithm}{A character string specifying which clustering algorithm is used,
i.e., k-means(\code{"kmeans"}) or k-medians (\code{"kmedians"}).}

\item{seed}{Seed to be used in the procedure.}
}
\value{
A list containing the following items:
\item{measure}{A measure of...}
 \item{levels}{Original levels of the variable \code{fac}.}
 \item{cluster}{A vector of integers (from 1:k) indicating the cluster to
 which each curve is allocated.}
 \item{centers}{An object of class \code{survfit} containing the centroids
 (mean of the curves pertaining to the same group).}
 \item{curves}{An object of class \code{survfit} containing the survival
 curves for each population.}
}
\description{
Function for grouping survival curves, given a number k,
based on the k-means or k-medians algorithm.
}
\examples{
library(clustcurv)
library(survival)
data(veteran)

# 2 groups k-means
cl2 <- kgroups_surv(time = veteran$time, status = veteran$status,
fac = veteran$celltype, k = 2, algorithm = "kmeans")

data.frame(level = cl2$level, cluster = cl2$cluster)


# 2 groups k-medians
cl2 <- kgroups_surv(time = veteran$time, status = veteran$status,
fac = veteran$celltype, k = 2, algorithm = "kmedians")

data.frame(level = cl2$level, cluster = cl2$cluster)



# 3 groups
cl3 <- kgroups_surv(time = veteran$time, status = veteran$status,
fac = veteran$celltype, k = 3, algorithm = "kmeans")

data.frame(level = cl3$level, cluster = cl3$cluster)

}
\author{
Marta Sestelo, Nora M. Villanueva.
}
