% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh.R
\name{projection.points.2.5D}
\alias{projection.points.2.5D}
\title{Project 3D points onto 2D 2.5D triangular mesh}
\usage{
projection.points.2.5D(mesh, locations)
}
\arguments{
\item{mesh}{A mesh.2.5D object representing the triangular mesh, created by \link{create.mesh.2.5D}.}

\item{locations}{3D points to be projected onto 2.5D triangular mesh.}
}
\value{
3D points projected onto 2.5D triangluar mesh.
}
\description{
This function projects any 3D points onto 2.5D triangular mesh.
}
\examples{
library(fdaPDE)

## Upload the hub2.5D the data
data(hub2.5D)
hub2.5D.nodes = hub2.5D$hub2.5D.nodes
hub2.5D.triangles = hub2.5D$hub2.5D.triangles

## Create mesh
mesh = create.mesh.2.5D(nodes = hub2.5D.nodes, triangles = hub2.5D.triangles)

## Create 3D points to be projected
x <- cos(seq(0,2*pi, length.out = 9))
y <- sin(seq(0,2*pi, length.out = 9))
z <- rep(0.5, 9)
locations = cbind(x,y,z)

## Project the points on the mesh
loc = projection.points.2.5D(mesh, locations)
}
