% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscb_layer.R
\name{uscb_layer}
\alias{uscb_layer}
\title{\code{uscb_layer} S3 class}
\usage{
uscb_layer(metadata, ua, geodatabase, year, folder = NULL)
}
\arguments{
\item{metadata}{A metadata object.}

\item{ua}{A \code{uscb_acs_5ye} object.}

\item{geodatabase}{A string.}

\item{year}{A integer}

\item{folder}{A string.}
}
\value{
A \code{uscb_layer} object.
}
\description{
A \code{uscb_layer} object is created from the available metadata, a
\code{uscb_acs_5ye} object, a geodatabase name, and a year.
}
\details{
If the folder is not indicated, it is considered that of the \code{uscb_acs_5ye}
object class.
}
\examples{

folder <- system.file("extdata", package = "geogenr")
folder <- stringr::str_replace_all(paste(folder, "/", ""), " ", "")
ua <- uscb_acs_5ye(folder = folder)
sa <- ua |> get_statistical_areas()

# sa[6]
# [1] "New England City and Town Area Division"

ul <- uscb_layer(uscb_acs_metadata, ua = ua, geodatabase = sa[6], year = 2015)

}
\seealso{
Other data selection functions: 
\code{\link{get_layer_group_names}()},
\code{\link{get_layer_group}()},
\code{\link{get_layer_names}()},
\code{\link{get_layer}()},
\code{\link{uscb_folder}()}
}
\concept{data selection functions}
