% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-modelsearch2.R
\name{getStep}
\alias{getStep}
\alias{getStep.modelsearch2}
\title{Extract one Step From the Sequential Procedure}
\usage{
getStep(object, ...)

\method{getStep}{modelsearch2}(object, step = nStep(object), slot = NULL,
  ...)
}
\arguments{
\item{object}{a modelsearch2 object}

\item{...}{not used.}

\item{step}{which test should be extracted?}

\item{slot}{the element from the modelsearch2 object that should be extracted.}
}
\description{
Extract one step from the sequential procedure.
}
\examples{
mSim <- lvm(Y~G+X1+X2)
addvar(mSim) <- ~Z1+Z2+Z3+Z4+Z5+Z6
df.data <- lava::sim(mSim, 1e2)

mBase <- lvm(Y~G)
addvar(mBase) <- ~X1+X2+Z1+Z2+Z3+Z4+Z5+Z6
e.lvm <- estimate(mBase, data = df.data)
res <- modelsearch2(e.lvm, statistic = "score", method.p.adjust = "holm")
getStep(res)
getStep(res, slot = "sequenceTest")
getStep(res, slot = "sequenceQuantile")
getStep(res, step = 1)

}
