% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareScore2.R
\name{prepareScore2}
\alias{prepareScore2}
\alias{prepareScore2.gls}
\alias{prepareScore2.lme}
\alias{prepareScore2<-}
\alias{prepareScore2<-.lvmfit}
\alias{prepareScore2.lvm}
\alias{prepareScore2.lvmfit}
\alias{prepareScore2<-}
\alias{prepareScore2<-.lvmfit}
\title{Prepare the Computation of score2}
\usage{
prepareScore2(object, ...)

\method{prepareScore2}{gls}(object, X, param, attr.param, second.order,
  n.cluster, n.endogenous, name.endogenous, index.obs, ...)

\method{prepareScore2}{lme}(object, X, param, attr.param, second.order,
  n.cluster, n.endogenous, name.endogenous, index.obs, ...)

prepareScore2(x, ...) <- value

\method{prepareScore2}{lvmfit}(x, ...) <- value

\method{prepareScore2}{lvm}(object, data, second.order,
  name.endogenous = NULL, name.latent = NULL, ...)

\method{prepareScore2}{lvmfit}(object, data = NULL, p = NULL,
  usefit = TRUE, name.endogenous = NULL, name.latent = NULL,
  second.order = FALSE, ...)

prepareScore2(x, ...) <- value

\method{prepareScore2}{lvmfit}(x, ...) <- value
}
\arguments{
\item{object}{a latent variable model.}

\item{...}{[internal] Only used by the generic method.}

\item{X}{the design matrix.}

\item{param}{the fitted parameters.}

\item{attr.param}{the type of each parameter (e.g. mean or variance parameter).}

\item{second.order}{should the terms relative to the third derivative of the likelihood be be pre-computed?}

\item{n.cluster}{the number of i.i.d. observations.}

\item{n.endogenous}{the number of outcomes}

\item{name.endogenous}{[optional] name of the endogenous variables}

\item{index.obs}{the indexes of the outcomes relative to each observation (e.g. 1,3 if only outcome 1 and 3 are observed for the observation).}

\item{x}{same as object.}

\item{value}{same as usefit.}

\item{data}{[optional] data set.}

\item{name.latent}{[optional] name of the latent variables}

\item{p}{same as param.}

\item{usefit}{If TRUE the parameters estimated by the model are used to pre-compute quantities. Only for lvmfit objects.}
}
\description{
Compute partial derivatives regarding to the mean and the variance, and compute the design matrices.
}
\details{
For lvmfit objects, there are two levels of pre-computation:
\itemize{
\item a basic one that do no involve the model parameter
\item an advanced one that require the model parameters. 
}
}
\examples{
m <- lvm(Y1~eta,Y2~eta,Y3~eta)
latent(m) <- ~eta

e <- estimate(m, lava::sim(m,1e2))
res <- prepareScore2(e)
res$skeleton$df.param
}
