% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_centrality.R
\name{centralisation}
\alias{centralisation}
\alias{network_degree}
\alias{network_closeness}
\alias{network_betweenness}
\alias{network_eigenvector}
\title{Measures of network centralisation}
\usage{
network_degree(object, normalized = TRUE, direction = c("all", "out", "in"))

network_closeness(object, normalized = TRUE, direction = c("all", "out", "in"))

network_betweenness(
  object,
  normalized = TRUE,
  direction = c("all", "out", "in")
)

network_eigenvector(object, normalized = TRUE)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{normalized}{Logical scalar, whether the centrality scores are normalized.
Different denominators are used depending on whether the object is one-mode or two-mode,
the type of centrality, and other arguments.}

\item{direction}{Character string, “out” bases the measure on outgoing ties,
“in” on incoming ties, and "all" on either/the sum of the two.
For two-mode networks, "all" uses as numerator the sum of differences
between the maximum centrality score for the mode
against all other centrality scores in the network,
whereas "in" uses as numerator the sum of differences
between the maximum centrality score for the mode
against only the centrality scores of the other nodes in that mode.}
}
\description{
Measures of network centralisation
}
\section{Functions}{
\itemize{
\item \code{network_degree()}: Calculate the degree centralization for a graph

\item \code{network_closeness()}: Calculate the closeness centralization for a graph

\item \code{network_betweenness()}: Calculate the betweenness centralization for a graph

\item \code{network_eigenvector()}: Calculate the eigenvector centralization for a graph

}}
\examples{
network_degree(ison_southern_women, direction = "in")
network_closeness(ison_southern_women, direction = "in")
network_betweenness(ison_southern_women, direction = "in")
network_eigenvector(mpn_elite_mex)
network_eigenvector(ison_southern_women)
}
\seealso{
Other measures: 
\code{\link{centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{diversity}},
\code{\link{features}},
\code{\link{holes}},
\code{\link{tie_centrality}}
}
\concept{measures}
