% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centralization.R
\name{centralization}
\alias{centralization}
\alias{graph_degree}
\alias{graph_closeness}
\alias{graph_betweenness}
\alias{graph_eigenvector}
\title{Centralization for one- and two-mode networks}
\usage{
graph_degree(
  object,
  directed = c("all", "out", "in", "total"),
  normalized = TRUE,
  digits = 2
)

graph_closeness(
  object,
  directed = c("all", "out", "in", "total"),
  normalized = TRUE,
  digits = 2
)

graph_betweenness(
  object,
  directed = c("all", "out", "in", "total"),
  normalized = TRUE,
  digits = 2
)

graph_eigenvector(object, digits = 2)
}
\arguments{
\item{object}{A matrix, igraph graph, or tidygraph object.}

\item{directed}{Character string, “out” for out-degree,
“in” for in-degree, and "all" or “total” for the sum of the two.
For two-mode networks, "all" uses as numerator the sum of differences
between the maximum centrality score for the mode
against all other centrality scores in the network,
whereas "in" uses as numerator the sum of differences
between the maximum centrality score for the mode
against only the centrality scores of the other nodes in that nodeset.}

\item{normalized}{Logical scalar, whether the centrality scores are normalized.
Different denominators are used depending on whether the object is one-mode or two-mode,
the type of centrality, and other arguments.}

\item{digits}{whether to round the resulting score, by default 2.
Add FALSE to turn all rounding off.}
}
\value{
A single centralization score if the object was one-mode,
and two centralization scores if the object was two-mode.
In the case of a two-mode network,
to return just the score for the first nodeset (rows),
append \verb{$nodes1} to the end of the function call or returned object.
To return just the score for the second nodeset (cols),
append \verb{$nodes2} to the end of the function call or returned object.
}
\description{
These functions measure the overall centralization for a network.
}
\examples{
graph_degree(ison_southern_women, directed = "in")
graph_closeness(ison_southern_women, directed = "in")
graph_betweenness(ison_southern_women, directed = "in")
graph_eigenvector(mpn_elite_mex)
}
\references{
Borgatti, Stephen P, and Daniel S Halgin. 2011. ``Analyzing Affiliation Networks." In \emph{The SAGE Handbook of
Social Network Analysis}, edited by John Scott and Peter J Carrington, 417–33. London, UK: Sage.
}
\seealso{
Other two-mode measures: 
\code{\link{centrality}},
\code{\link{cohesion}()},
\code{\link{graph_smallworld}()},
\code{\link{node_constraint}()}
}
\concept{graph-level measures}
\concept{two-mode measures}
