% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library.R
\name{md.death}
\alias{md.death}
\title{md.death}
\usage{
md.death(name, poptable, sexcol, birthcol, startcol)
}
\arguments{
\item{name}{name of the column}

\item{poptable}{population mortality table used to simulate times od death}

\item{sexcol}{name of the column (covariate) specifying birth date}

\item{birthcol}{name of the column (covariate) specifying birth date}

\item{startcol}{name of the column (covariate) specifying the start date from which to calculate time of death}
}
\description{
Creates information of a time of death variable distributed according to the specified population mortality table and demographic information.
This function call must be added to the \code{\link{md.simparams}} object.
}
\examples{

\dontrun{
library(missDeaths)

sim = md.simparams() +
   md.sex("sex", 0.5) + 
     md.uniform("birth", as.Date("1930-1-1"), as.Date("1960-1-1")) +
       md.uniform("start", as.Date("2005-1-1"), as.Date("2010-1-1")) +
         md.death("death", survexp.us, "sex", "birth", "start") 
}
}
