% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serch_gids.R
\name{search_gids}
\alias{search_gids}
\title{Search the internal game_id data set.}
\usage{
search_gids(team = NULL, start = NULL, end = NULL, venue = NULL,
  game_type = NULL, home_only = FALSE, away_only = FALSE, ...)
}
\arguments{
\item{team}{A team name, or character vector of team names, without the city, as found in the \code{team_ids} data set.}

\item{start}{A start date passed as a character in ISO 8601 format. \code{"2017-05-01"}}

\item{end}{An end date passed as a character in ISO 8601 format. \code{"2017-09-01"}}

\item{venue}{The stadium at which the game(s) were played, as found in the \code{venue_ids} data set.}

\item{game_type}{The type of game(s), as found in the \code{game_ids} data set. Typical options include \code{"r"} (regular),
\code{"w"} (world series), \code{"l"} (league playoffs), \code{"d"} (division playoffs), and \code{"s"} (spring training).}

\item{home_only}{Logical. Collect only home games. The default is FALSE.}

\item{away_only}{Logical. Collect only away games. The default is FALSE.}

\item{...}{additional arguments}
}
\description{
Search the internal game_id data set.
}
\examples{

# Collect all of the regular season games for the 2016 Cleveland Indians.
game_ids <- search_gids(team = "indians", start = "2016-01-01", end = "2016-12-31", game_type = "r")
head(game_ids)

\dontrun{
# Collect all games from the 2016 World Series
game_ids <- search_gids(start = "2016-10-25", end = "2016-11-02", game_type = "w")

# Collect all regular season games played at Wrigley Field since 2008.
game_ids <- search_gids(venue = "Wrigley Field")

# Fuzzy search results work too.
game_ids <- search_gids(venue = "Wrigley")

}
}
