% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{setMutClusterParams}
\alias{setMutClusterParams}
\title{Set Parameters for Extracting Mutational Signatures.}
\usage{
setMutClusterParams(num_processesToExtract = 2, num_totIterations = 10,
  num_parallelCores = 1, thresh_removeWeakMutTypes = 0.01,
  thresh_removeLastPercent = 0.07, distanceFunction = "cosine",
  num_totReplicates = 100, eps = 2.2204e-16, stopconv = 20000,
  niter = 1e+06, guided = TRUE, debug = FALSE, approach = "freq",
  stopRule = "DF", algorithm = "brunet", logIterations = "lite",
  seed = 12345)
}
\arguments{
\item{num_processesToExtract}{integer, number of mutational signatures to extract}

\item{num_totIterations}{integer, total number of iterations (bootstrapping)}

\item{num_parallelCores}{integer, number of cores to use for the analysis}

\item{thresh_removeWeakMutTypes}{numeric, threshold for filtering out under-represented mutation types}

\item{thresh_removeLastPercent}{numeric, threshold for removing outlier iteration results}

\item{distanceFunction}{string, method for calculating distances. Default method is "cosine"}

\item{num_totReplicates}{integer, number of replicates while checking stability}

\item{eps}{numeric, close-to-zero positive numeric value for replacing zeros and 
preventing negative values to appear in the matrix during NMF}

\item{stopconv}{integer, max number of stable iterations before termination. Defaults to 20000.}

\item{niter}{integer, max number of iterations to run. Defaults to 1000000}

\item{guided}{logical, shall clustering be guided to improve aggregation upon bootstrapping}

\item{debug}{logical, shall the analysis be run in DEBUG mode}

\item{approach}{string, indicating whether to model absolute counts ("counts") or 
per_mille frequency ("freq"). Defaults to "freq".}

\item{stopRule}{= string, use the sub-optimal termination rule ("AL") from the WTSI package 
(actually, iterations won't terminate, so niter will most certainly reached) or our 
efficient termination rule ("DF"). Defaults to "DF". The "AL" option is implemented for 
compatibility reasons, but not recommended.}

\item{algorithm}{string, algorithm to be used for NMF. Set to "brunet", or "alexa" for using the standard algorithm (Brunet's), 
otherwise the alternative "chihjen" algorithm will be used.}

\item{logIterations}{string indicating if storing and returining all intermediates, 
or only final results. Defaults to "lite", i.e. returns full output and limited intermediates.
Alternatively, set to "full".}

\item{seed}{integer, seed to set for reproducibility}
}
\value{
Object including all parameters for running the analysis
}
\description{
Create an object including all parameters required for running the mutSignatures framework.
}
\examples{
library(mutSignatures) 
# defaults params
A <- setMutClusterParams()
A
# A second example, set num_processes
B <- setMutClusterParams(num_processesToExtract = 5)
B

    
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{Official website}: \url{http://www.mutsignatures.org}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item WTSI framework: \url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3588146/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
