# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Returns the gradient for FOCEi environment
#' @param rho Environment to calculate the gradient for...
#' @export
#' @keywords internal
rxGrad <- function(rho) {
    invisible(.Call(`_nlmixr_rxGrad`, rho))
}

rxInnerNum <- function(etanews, rho) {
    invisible(.Call(`_nlmixr_rxInnerNum`, etanews, rho))
}

rxInner <- function(etanews, rho) {
    invisible(.Call(`_nlmixr_rxInner`, etanews, rho))
}

#' Get the Hessian for the environment
#' @param rho environment
#' @export
#' @keywords internal
rxHessian <- function(rho) {
    invisible(.Call(`_nlmixr_rxHessian`, rho))
}

#' Get the likelihood for ETA
#' @param sexp_eta ETA for likelihood
#' @param sexp_rho Environment with solving options
#' @export
#' @keywords internal
RxODE_focei_eta_lik <- function(sexp_eta, sexp_rho) {
    .Call(`_nlmixr_RxODE_focei_eta_lik`, sexp_eta, sexp_rho)
}

#' Get the likelihood slope for ETA
#' @inheritParams RxODE_focei_eta_lik
#' @export
#' @keywords internal
RxODE_focei_eta_lp <- function(sexp_eta, sexp_rho) {
    .Call(`_nlmixr_RxODE_focei_eta_lp`, sexp_eta, sexp_rho)
}

#' Get the Function pointers for the LBJ'S routine
#' @param fstr a string of the function pointer to return.  "lik" for likelihood and "lp" for likelihood gradient.
#' @export
#' @keywords internal
RxODE_focei_eta <- function(fstr) {
    .Call(`_nlmixr_RxODE_focei_eta`, fstr)
}

#' Finalize likelihood environment
#' @param  rho Environment to finalize.  Returns an individual likelihood. 
#' @export
#' @keywords internal
RxODE_focei_finalize_llik <- function(rho) {
    .Call(`_nlmixr_RxODE_focei_finalize_llik`, rho)
}

rxDetaDomega <- function(rho) {
    invisible(.Call(`_nlmixr_rxDetaDomega`, rho))
}

rxOuter_ <- function(rho) {
    invisible(.Call(`_nlmixr_rxOuter_`, rho))
}

rxDetaDtheta <- function(rho) {
    invisible(.Call(`_nlmixr_rxDetaDtheta`, rho))
}

rxOuter <- function(rho) {
    .Call(`_nlmixr_rxOuter`, rho)
}

#' Update ETAs based on d(eta)/d(theta)
#'
#' This updates the ETA initial estimates based on the knowledge of d(eta)/d(theta)
#'
#' @param DnDhS This is the d(eta)/d(theta) list where there is a
#'   d(eta)/d(theta) matrix for each subject
#'
#' @param DhS This is the change in theta observed between steps.
#'
#' @param initS This is the ETA initial condition matrix
#'
#' @param acceptNS Acceptance criteria for the new eta.  |eta| < acceptNS for the new eta
#'   to be accepted.
#'
#' @keywords internal
#'
#' @export
rxUpdateEtas <- function(DnDhS, DhS, initS, acceptNS) {
    .Call(`_nlmixr_rxUpdateEtas`, DnDhS, DhS, initS, acceptNS)
}

sFOCEi <- function(par, e) {
    .Call(`_nlmixr_sFOCEi`, par, e)
}

grFOCEi <- function(par, e) {
    .Call(`_nlmixr_grFOCEi`, par, e)
}

lin_cmt_stan <- function(obs_time, dose_time, dose, Tinf, params, oralSEXP, infusionSEXP, ncmtSEXP, parameterizationSEXP) {
    .Call(`_nlmixr_lin_cmt_stan`, obs_time, dose_time, dose, Tinf, params, oralSEXP, infusionSEXP, ncmtSEXP, parameterizationSEXP)
}

llik_binomial_c <- function(y, N, params) {
    .Call(`_nlmixr_llik_binomial_c`, y, N, params)
}

llik_poisson <- function(y, params) {
    .Call(`_nlmixr_llik_poisson`, y, params)
}

llik_normal <- function(y, params) {
    .Call(`_nlmixr_llik_normal`, y, params)
}

llik_betabinomial <- function(y, N, params) {
    .Call(`_nlmixr_llik_betabinomial`, y, N, params)
}

llik_student_t <- function(y, params) {
    .Call(`_nlmixr_llik_student_t`, y, params)
}

llik_beta <- function(y, params) {
    .Call(`_nlmixr_llik_beta`, y, params)
}

llik_neg_binomial <- function(y, params) {
    .Call(`_nlmixr_llik_neg_binomial`, y, params)
}

