% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_store.R
\name{tbl_get}
\alias{tbl_get}
\title{Obtain a materialized table via a table store}
\usage{
tbl_get(tbl, store = NULL)
}
\arguments{
\item{tbl}{The table to retrieve from a table \code{store}. This table could be
identified by its name (e.g., \code{tbl = "large_table"}) or by supplying a
reference using a subset (with \code{$}) of the \code{tbl_store} object (e.g., \code{tbl = store$large_table}). If using the latter method then nothing needs to be
supplied to \code{store}.}

\item{store}{Either a table store object created by the \code{\link[=tbl_store]{tbl_store()}}
function or a path to a table store YAML file created by \code{\link[=yaml_write]{yaml_write()}}.}
}
\value{
A table object.
}
\description{
The \code{tbl_get()} function gives us the means to materialize a table that has
an entry in a table store (i.e., has a table-prep formula with a unique
name). The table store that is used for this can be in the form of a
\code{tbl_store} object (created with the \code{\link[=tbl_store]{tbl_store()}} function) or an on-disk
YAML representation of a table store (created by using \code{\link[=yaml_write]{yaml_write()}} with a
\code{tbl_store} object).

Should you want a table-prep formula from a table store to use as a value for
\code{read_fn} (in \code{\link[=create_agent]{create_agent()}}, \code{\link[=create_informant]{create_informant()}}, or \code{\link[=set_read_fn]{set_read_fn()}}),
then have a look at the \code{\link[=tbl_source]{tbl_source()}} function.
}
\section{Function ID}{

1-10
}

\examples{
if (interactive()) {

# Define a `tbl_store` object by adding
# table-prep formulas in `tbl_store()`
tbls <- 
  tbl_store(
    small_table_duck ~ db_tbl(
      table = small_table,
      dbname = ":memory:",
      dbtype = "duckdb"
    ),
    ~ db_tbl(
      table = "rna",
      dbname = "pfmegrnargs",
      dbtype = "postgres",
      host = "hh-pgsql-public.ebi.ac.uk",
      port = 5432,
      user = I("reader"),
      password = I("NWDMCE5xdipIjRrp")
    ),
    all_revenue ~ db_tbl(
      table = file_tbl(
        file = from_github(
          file = "all_revenue_large.rds",
          repo = "rich-iannone/intendo",
          subdir = "data-large"
        )
      ),
      dbname = ":memory:",
      dbtype = "duckdb"
    ),
    sml_table ~ pointblank::small_table
  )

# Once this object is available, you can
# check that the table of interest is
# produced to your specification
tbl_get(
  tbl = "small_table_duck",
  store = tbls
)

# An alternative method for getting the
# same table materialized is by using `$`
# to get the formula of choice from `tbls`
tbls$small_table_duck \%>\% tbl_get()

}

}
\seealso{
Other Planning and Prep: 
\code{\link{action_levels}()},
\code{\link{create_agent}()},
\code{\link{create_informant}()},
\code{\link{db_tbl}()},
\code{\link{file_tbl}()},
\code{\link{scan_data}()},
\code{\link{tbl_source}()},
\code{\link{tbl_store}()},
\code{\link{validate_rmd}()}
}
\concept{Planning and Prep}
