% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_groups.R
\name{with_groups}
\alias{with_groups}
\title{Perform an operation with temporary groups}
\usage{
with_groups(.data, .groups, .f, ...)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{.groups}{<\code{\link[=select_helpers]{poor-select}}> One or more variables to group by. Unlike \code{\link[=group_by]{group_by()}}, you can
only group by existing variables, and you can use \code{poor-select} syntax like \code{c(x, y, z)} to select multiple
variables.

Use \code{NULL} to temporarily \strong{un}group.}

\item{.f}{A \code{function} to apply to regrouped data. Supports lamba-style \code{~} syntax.}

\item{...}{Additional arguments passed on to \code{.f}.}
}
\description{
This function allows you to modify the grouping variables for a single operation.
}
\examples{
df <- data.frame(g = c(1, 1, 2, 2, 3), x = runif(5))
df \%>\% with_groups(g, mutate, x_mean = mean(x))
df \%>\% with_groups(g, ~ mutate(.x, x_mean = mean(x)))

df \%>\%
  group_by(g) \%>\%
  with_groups(NULL, mutate, x_mean = mean(x))

# NB: grouping can't be restored if you remove the grouping variables
df \%>\%
  group_by(g) \%>\%
  with_groups(NULL, mutate, g = NULL)

}
