% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{maccann2020}
\alias{maccann2020}
\title{Studies examining whether student emotional intelligence is associated with academic performance}
\format{
A data frame with 1246 rows and 19 variables:
\itemize{
\item \code{study_id}: unique id of study
\item \code{sample_id}: unique id of sample
\item \code{es_id}: unique id of effect size
\item \code{author}: author of study
\item \code{pub_year}: year of study publication
\item \code{yi}: effect size (r)
\item \code{vi}: sampling variance for effect (SE^2)
\item \code{pub_type}: publication type (0 = journal article, 1 = dissertation, 2 = conference proceedings, 3 = unpublished data)
\item \code{n}: number of participants contributing to  effect size
\item \code{ed_level1}: level of education of the sample at the time of data collection (0 = primary, 1 = secondary, 2 = tertiary, 3 = mixed)
\item \code{ed_level2}: level of education based on the type of academic achievement reported (0 = primary, 1 = secondary, 2 = tertiary, 3 = mixed)
\item \code{country}: country where the participants in the studies were from
\item \code{perc_white}: percentage of the sample categorized as "white" (USA samples only)
\item \code{age}: mean age of the sample
\item \code{perc_female}: percentage of sample who are female
\item \code{ei_construct}: the EI facet or construct represented (0 = overall ei, 2 = perception, 2 = facilitation, 3 = understanding, 4 = management, 5 = intrapersonal, 6 = interpersonal, 7 = stress management, 8 = adaptability, 9 = general mood)
\item \code{ei_stream}: the stream (or type) of EI instrument used (1 = maximum-performance ability tests, 2 = rating scales based on ability models, 3 = other broader models of EI that include non-ability constructs)
\item \code{ei_measure}: the test of EI used (1.1 = MSCEIT, 1.2 = MEIS, 1.3 = DANVA, 1.4 = STEU, 1.5 = STEM, 2.1 = SUEIT, 2.2 = SSRI, 2.3 = SREIT, 2.4 = TMMS, 2.5 = WLEIS, 3.1 = EQi, 3.2 = TEIQue, 3.3 = ESAP)
\item \code{subject}: subject area of the academic performance (0 = general, 1 = verbal/language arts, 2 = math, 3 = science, 4 = social studies, 5 = foreign language, 6 = psychology, 7 = medicine, 8 = engineering, 9 = physical education, 10 = art)
\item \code{humanities}: subject area of the acadmeic performance, categorized as sciences versus humanities (0 = general, 1 = math and sciences, 2 = humanities and verbal abilities)
\item \code{achievement_type}: type of achievement (0 = course grade, 1 = standardized test)
}
}
\usage{
data("maccann2020")
}
\description{
Results from 158 studies, including 1246 effect sizes (r), on the relationship between emotional intelligence (EI) and academic performance \insertCite{maccann2020emotional}{psychmetadata}.
}
\details{
Further details can be found at \href{https://osf.io/hnmy4/}{https://osf.io/hnmy4/}
}
\references{
\insertAllCited{}
}
\keyword{datasets}
