% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_dataset.R
\name{Dataset_plot}
\alias{Dataset_plot}
\alias{plot.Dataset}
\title{Dataset Plotting}
\usage{
\method{plot}{Dataset}(x, y, ..., main = "Dataset", xlab = "Stage",
  ylab = NA_character_, legendTitle = "Group", palette = "Set1")
}
\arguments{
\item{x}{The \code{\link{Dataset}} object to plot.}

\item{y}{Not available for this kind of plot (is only defined to be compatible to the generic plot function).}

\item{...}{Optional \code{ggplot2} arguments.}

\item{main}{The main title, default is \code{"Dataset"}.}

\item{xlab}{The x-axis label, default is \code{"Stage"}.}

\item{ylab}{The y-axis label.}

\item{legendTitle}{The legend title, default is \code{"Group"}.}

\item{palette}{The palette, default is \code{"Set1"}.}
}
\description{
Plots a dataset.
}
\details{
Generic function to plot all kinds of datasets.
}
\examples{

# Plot a dataset of means
dataExample <- getDataset(
    n1 = c(22, 11, 22, 11),
    n2 = c(22, 13, 22, 13),
    means1 = c(1, 1.1, 1, 1),
    means2 = c(1.4, 1.5, 3, 2.5),
    stDevs1 = c(1, 2, 2, 1.3),
    stDevs2 = c(1, 2, 2, 1.3))

if (require(ggplot2)) plot(dataExample, main = "Comparison of means")

# Plot a dataset of rates
dataExample <- getDataset(
    n1 = c(8, 10, 9, 11),
    n2 = c(11, 13, 12, 13),
    events1 = c(3, 5, 5, 6),
    events2 = c(8, 10, 12, 12)
)

if (require(ggplot2)) plot(dataExample, main = "Comparison of rates")

}
