% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_sample_size_calculator.R
\name{getSampleSizeSurvival}
\alias{getSampleSizeSurvival}
\title{Get Sample Size Survival}
\usage{
getSampleSizeSurvival(design, ..., typeOfComputation = "Schoenfeld",
  thetaH0 = 1, pi2 = 0.2, pi1 = seq(0.4, 0.6, 0.1),
  allocationRatioPlanned = 1, accountForObservationTimes = NA,
  eventTime = NA_real_, accrualTime = NA_real_, followUpTime = NA_real_,
  maxNumberOfPatients = 0, dropOutRate1 = 0, dropOutRate2 = 0,
  dropOutTime = NA_real_)
}
\arguments{
\item{design}{The trial design.}

\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{typeOfComputation}{Three options are available: "Schoenfeld", "Freedman", "HsiehFreedman", 
the default is "Schoenfeld". For details, see Hsieh (Statistics in Medicine, 1992).}

\item{thetaH0}{The null hypothesis value. The default value is 1. For one-sided testing, 
a bound for testing H0: log(1 - pi1)/log(1 - pi2) = thetaH0 != 1 can be specified.}

\item{pi2}{The assumed event rate in the control group, default is 0.2.}

\item{pi1}{The assumed event rate in the treatment group, default is seq(0.4, 0.6, 0.1).}

\item{allocationRatioPlanned}{The planned allocation ratio, default is 1. 
If \code{allocationRatioPlanned = 0} is entered, the optimal allocation ratio yielding the 
smallest number of patients is determined.}

\item{accountForObservationTimes}{If \code{accountForObservationTimes = TRUE}, the number of 
patients is calculates assuming assuming specific accrual and follow-up time. 
The formula of Kim & Tsiatis (Biometrics, 1990) is used to calculated the expected 
number of events under the alternative (see also Lakatos & Lan, Statistics in Medicine, 1992).}

\item{eventTime}{The assumed time under which the event rates are calculated 
(need to be specified if \code{accountForObservationTimes = TRUE}).}

\item{accrualTime}{The assumed accrual time for the study (need to be specified if \cr 
\code{accountForObservationTimes = TRUE}).}

\item{followUpTime}{The assumed (additional) follow-up time for the study 
(need to be specified if \code{accountForObservationTimes = TRUE}). 
The total study duration is accrualTime + followUpTime.}

\item{maxNumberOfPatients}{For \code{accountForObservationTimes = TRUE}, if \cr
\code{maxNumberOfPatients > 0} is specified, the follow-up time for the required 
number of events is determined.}

\item{dropOutRate1}{The assumed drop-out rate in the control group, default is 0.}

\item{dropOutRate2}{The assumed drop-out rate in the treatment group, default is 0.}

\item{dropOutTime}{The assumed time for drop-out rates in the control and the 
treatment group, default is 12.}
}
\value{
Returns a \code{TrialDesignPlanSurvival} object.
}
\description{
Returns the sample size for testing the hazard ratio in a two treatment groups survival design.
}
\details{
At given design the function calculates the number of events and an estimate for the 
necessary number of patients for testing the 
hazard ratio log(1 - p1)/log(1 - p2) with no interim stages. 
Accordingly, an event probability omega is calculated.
It also calculates the time when the required events are expected under the given 
assumptions (assuming exponentially distributed survival times). 
Furthermore, an allocation ratio = n1Fixed/n2Fixed can be specified.
}
\examples{

# Calculate the number of events and number of patients calculated with 
# the Schoenfeld formula.
getSampleSizeSurvival(getDesignGroupSequential(alpha = 0.025, beta = 0.2, 
    sided = 1), thetaH0 = 1, pi1 = 0.6, pi2 = 0.9, 
    allocationRatioPlanned = 2, typeOfComputation = "Schoenfeld")

# Calculate analysis times, number of aevent, and number of patients 
# under specified event, accrual, followup, and dropout time and event 
# and dropout rates.
getSampleSizeSurvival(getDesignGroupSequential(alpha = .025, sided = 1), 
    pi1 = c(0.25, 0.3, 0.35), pi2 = 0.4, allocationRatioPlanned = 0, 
    typeOfComputation = "Schoenfeld", accountForObservationTimes = TRUE,
    eventTime = 12, accrualTime = 6, followUpTime = 12, 
    maxNumberOfPatients = 0, dropOutRate1 = 0.15, dropOutRate2 = 0.1, 
    dropOutTime = 24)

}
