% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_plan_count_data.R
\name{getPowerCounts}
\alias{getPowerCounts}
\title{Get Power Counts}
\usage{
getPowerCounts(
  design = NULL,
  ...,
  directionUpper = NA,
  maxNumberOfSubjects = NA_real_,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  lambda = NA_real_,
  theta = NA_real_,
  thetaH0 = 1,
  overdispersion = 0,
  fixedExposureTime = NA_real_,
  accrualTime = NA_real_,
  accrualIntensity = NA_real_,
  followUpTime = NA_real_,
  allocationRatioPlanned = NA_real_
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used.
In this case, Type I error rate \code{alpha}, Type II error rate \code{beta}, \code{twoSidedPower},
and \code{sided} can be directly entered as argument where necessary.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and
that a warning will be displayed if unknown arguments are passed.}

\item{directionUpper}{Logical. Specifies the direction of the alternative,
only applicable for one-sided testing; default is \code{TRUE}
which means that larger values of the test statistics yield smaller p-values.}

\item{maxNumberOfSubjects}{\code{maxNumberOfSubjects > 0} needs to be specified for power calculations or calculation
of necessary follow-up (count data). For two treatment arms, it is the maximum number of subjects for both treatment arms.}

\item{lambda1}{A numeric value or vector that represents the assumed rate of a homogeneous Poisson process in
the active treatment group, there is no default.}

\item{lambda2}{A numeric value that represents the assumed rate of a homogeneous Poisson process in
the control group, there is no default.}

\item{lambda}{A numeric value or vector that represents the assumed rate of a homogeneous Poisson process in
the pooled treatment groups, there is no default.}

\item{theta}{A numeric value or vector that represents the assumed mean ratios lambda1/lambda2 of a homogeneous
Poisson process, there is no default.}

\item{thetaH0}{The null hypothesis value,
default is \code{0} for the normal and the binary case (testing means and rates, respectively),
it is \code{1} for the survival case (testing the hazard ratio).\cr\cr
For non-inferiority designs, \code{thetaH0} is the non-inferiority bound.
That is, in case of (one-sided) testing of
\itemize{
\item \emph{means}: a value \code{!= 0}
(or a value \code{!= 1} for testing the mean ratio) can be specified.
\item \emph{rates}: a value \code{!= 0}
(or a value \code{!= 1} for testing the risk ratio \code{pi1 / pi2}) can be specified.
\item \emph{survival data}: a bound for testing H0: \code{hazard ratio = thetaH0 != 1} can be specified.
\item \emph{count data}: a bound for testing H0: \code{lambda1 / lambda2 = thetaH0 != 1} can be specified.
}
For testing a rate in one sample, a value \code{thetaH0} in (0, 1) has to be specified for
defining the null hypothesis H0: \code{pi = thetaH0}.}

\item{overdispersion}{A numeric value that represents the assumed overdispersion of the negative binomial distribution,
default is \code{0}.}

\item{fixedExposureTime}{If specified, the fixed time of exposure per subject for count data, there is no default.}

\item{accrualTime}{If specified, the assumed accrual time interval(s) for the study, there is no default.}

\item{accrualIntensity}{If specified, the assumed accrual intensities for the study, there is no default.}

\item{followUpTime}{If specified, The assumed (additional) follow-up time for the study, there is no default.
The total study duration is \code{accrualTime + followUpTime}.}

\item{allocationRatioPlanned}{The planned allocation ratio \code{n1 / n2} for a two treatment groups
design, default is \code{1}. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control.
For simulating means and rates for a two treatment groups design, it can be a vector of length kMax, the number of stages.
It can be a vector of length kMax, too, for multi-arm and enrichment designs.
In these cases, a change of allocating subjects to treatment groups over the stages can be assessed.}
}
\value{
Returns a \code{\link{TrialDesignPlan}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
\item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
\item \code{\link[=print.FieldSet]{print()}} to print the object,
\item \code{\link[=summary.TrialDesignSet]{summary()}} to display a summary of the object,
\item \code{\link[=plot.TrialDesignPlan]{plot()}} to plot the object,
\item \code{\link[=as.data.frame.TrialDesignPlan]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
\item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the power, stopping probabilities, and expected sample size for testing mean rates
for negative binomial distributed event numbers in two samples at given sample sizes.
}
\details{
At given design the function calculates the power, stopping probabilities, and expected sample size
for testing the ratio of two mean rates of negative binomial distributed event numbers in two samples
at given maximum sample size and effect.
The power calculation is performed either for a fixed exposure time or a variable exposure time with fixed follow-up
where the information over the stages is calculated according to the specified information rate in the design.
Additionally, an allocation ratio = \code{n1 / n2} can be specified where \code{n1} and \code{n2} are the number
of subjects in the two treatment groups. A null hypothesis value \code{thetaH0} can also be specified.
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of
the \code{rpact} specific implementation of the generic.
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and
to identify the object specific name of it, e.g.,
use \code{methods("plot")} to get all the methods for the \code{plot} generic.
There you can find, e.g., \code{plot.AnalysisResults} and
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
# Fixed sample size trial where a therapy is assumed to decrease the 
# exacerbation rate from 1.4 to 1.05 (25\% decrease) within an 
# observation period of 1 year, i.e., each subject has a equal 
# follow-up of 1 year.
# Calculate power at significance level 0.025 at given sample size = 180 
# for a range of lambda1 values if the overdispersion is assumed to be 
# equal to 0.5, is obtained by
getPowerCounts(alpha = 0.025, lambda1 = seq(1, 1.4, 0.05), lambda2 = 1.4, 
    maxNumberOfSubjects = 180, overdispersion = 0.5, fixedExposureTime = 1)
\dontrun{
# Group sequential alpha and beta spending function design with O'Brien and 
# Fleming type boundaries: Power and test characteristics for N = 286, 
# under the assumption of a fixed exposure time, and for a range of 
# lambda1 values: 
getPowerCounts(design = getDesignGroupSequential(
        kMax = 3, alpha = 0.025, beta = 0.2, 
        typeOfDesign = "asOF", typeBetaSpending = "bsOF"), 
    lambda1 = seq(0.17, 0.23, 0.01), lambda2 = 0.3, 
    directionUpper = FALSE, overdispersion = 1, maxNumberOfSubjects = 286, 
    fixedExposureTime = 12, accrualTime = 6)

# Group sequential design alpha spending function design with O'Brien and 
# Fleming type boundaries: Power and test characteristics for N = 1976, 
# under variable exposure time with uniform recruitment over 1.25 months,
# study time (accrual + followup) = 4 (lambda1, lambda2, and overdispersion 
# as specified, no futility stopping):
getPowerCounts(design = getDesignGroupSequential(
        kMax = 3, alpha = 0.025, beta = 0.2, typeOfDesign = "asOF"),
    lambda1 = seq(0.08, 0.09, 0.0025), lambda2 = 0.125, 
    overdispersion = 5, directionUpper = FALSE, maxNumberOfSubjects = 1976, 
    followUpTime = 2.75, accrualTime = 1.25)
}

}
\seealso{
Other power functions: 
\code{\link{getPowerMeans}()},
\code{\link{getPowerRates}()},
\code{\link{getPowerSurvival}()}
}
\concept{power functions}
