% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_rtmpt_SBC.R
\name{sim_rtmpt_data_SBC}
\alias{sim_rtmpt_data_SBC}
\title{Simulate data from an RT-MPT model}
\usage{
sim_rtmpt_data_SBC(model, seed, n.subj, n.trials, params = NULL)
}
\arguments{
\item{model}{A list of the class \code{rtmpt_model}.}

\item{seed}{Random seed number.}

\item{n.subj}{<- Number of subjects.}

\item{n.trials}{<- Number of trials per tree.}

\item{params}{Named list of parameters from which the data will be generated. This must be the same named list as \code{prior_params} from 
\code{\link{fit_rtmpt}} and has the same defaults. It is not recommended to use the defaults since they lead to many probabilities close or 
equal to \code{0} and/or \code{1} and to RTs close or equal to \code{0}. Allowed parameters are:
\itemize{
  \item \code{mean_of_exp_mu_beta}: This is the expected exponential rate (\code{E(exp(beta)) = E(lambda)}) and 
        \code{1/mean_of_exp_mu_beta} is the expected process time (\code{1/E(exp(beta)) = E(tau)}). The default
        mean is set to \code{10}, such that the expected process time is \code{0.1} seconds.
  \item \code{var_of_exp_mu_beta}: The group-specific variance of the exponential rates. Since
        \code{exp(mu_beta)} is Gamma distributed, the rate of the distribution is just mean divided by variance and
        the shape is the mean times the rate. The default is set to \code{100}.
  \item \code{mean_of_mu_gamma}: This is the expected \emph{mean parameter} of the encoding and response execution times,
        which follow a normal distribution truncated from below at zero, so \code{E(mu_gamma) < E(gamma)}. The default is \code{0}.
  \item \code{var_of_mu_gamma}: The group-specific variance of the \emph{mean parameter}. Its default is \code{10}.
  \item \code{mean_of_omega_sqr}: This is the expected residual variance (\code{E(omega^2)}). The default is \code{0.005}.
  \item \code{var_of_omega_sqr}: The variance of the residual variance (\code{Var(omega^2)}). The default is
        \code{0.01}. The default of the mean and variance is equivalent to a shape and rate of \code{0.0025} and 
        \code{0.5}, respectivly.
  \item \code{df_of_sigma_sqr}: degrees of freedom for the individual variance of the response executions. The
        individual variance follows a scaled inverse chi-squared distribution with \code{df_of_sigma_sqr} degrees of freedom and
        \code{omega^2} as scale. \code{2} is the default and it should be an integer.
  \item \code{sf_of_scale_matrix_SIGMA}: The original scaling matrix (S) of the (scaled) inverse Wishart distribution for the process 
        related parameters is an identity matrix \code{S=I}. \code{sf_of_scale_matrix_SIGMA} is a scaling factor, that scales this 
        matrix (\code{S=sf_of_scale_matrix_SIGMA*I}). Its default is \code{1}.
  \item \code{sf_of_scale_matrix_GAMMA}: The original scaling matrix (S) of the (scaled) inverse Wishart distribution for the encoding and
        motor execution parameters is an identity matrix \code{S=I}. \code{sf_of_scale_matrix_GAMMA} is a scaling factor that scales 
        this matrix (\code{S=sf_of_scale_matrix_GAMMA*I}). Its default is \code{1}.
  \item \code{prec_epsilon}: This is epsilon in the paper. It is the precision of mu_alpha and all xi (scaling parameter
        in the scaled inverse Wishart distribution). Its default is also \code{1}.
  \item \code{add_df_to_invWish}: If \code{P} is the number of parameters or rather the size of the scale matrix used in the (scaled)
        inverse Wishart distribution then \code{add_df_to_invWish} is the number of degrees of freedom that can be added to it. So
        \code{DF = P + add_df_to_invWish}. The default for \code{add_df_to_invWish} is \code{1}, such that the correlations are uniformly 
        distributed within \code{[-1, 1]}.
}}
}
\value{
A list of the class \code{rtmpt_sim} containing 
  \itemize{
    \item \code{data}: the data.frame with the simulated data,
    \item \code{gen_list}: a list containing lists of the group-level and subject-specific parameters for the process-related parameters and the motor-related
                           parameters, and the trial-specific probabilities, process-times, and motor-times,
    \item \code{specs}: some specifications like the model, seed number, etc.,
  }
}
\description{
Simulate data from RT-MPT models using \code{rtmpt_model} objects. The difference to \code{\link{sim_rtmpt_data}} is that here only scalars are allowed. This makes it usable for 
  simulation-based calibration (SBC; Talts et al., 2018). You can specify the random seed, number of subjects, number of trials, and some
  parameters (same as \code{prior_params} from \code{\link{fit_rtmpt}}).
}
\examples{
########################################################################################
# Detect-Guess variant of the Two-High Threshold model.
# The encoding and motor execution times are assumed to be different for each response.
########################################################################################

mdl_2HTM <- "
# targets
do+(1-do)*g     ; 0
(1-do)*(1-g)    ; 1

# lures
(1-dn)*g        ; 0
dn+(1-dn)*(1-g) ; 1

# do: detect old; dn: detect new; g: guess
"

model <- to_rtmpt_model(mdl_file = mdl_2HTM)

params <- list(mean_of_exp_mu_beta = 10, 
               var_of_exp_mu_beta = 10, 
               mean_of_mu_gamma = 0.5, 
               var_of_mu_gamma = 0.0025, 
               mean_of_omega_sqr = 0.005, 
               var_of_omega_sqr = 0.000025,
               df_of_sigma_sqr = 10, 
               sf_of_scale_matrix_SIGMA = 0.1, 
               sf_of_scale_matrix_GAMMA = 0.01, 
               prec_epsilon = 10,
               add_df_to_invWish = 5)

sim_dat <- rtmpt:::sim_rtmpt_data_SBC(model, seed = 123, n.subj = 40, 
                                      n.trials = 30, params = params)

}
\references{
Talts, S., Betancourt, M., Simpson, D., Vehtari, A., & Gelman, A. (2018). Validating Bayesian inference algorithms with simulation-based calibration. \emph{arXiv preprint arXiv:1804.06788}.
}
\author{
Raphael Hartmann
}
