% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secsse_sim.R
\name{secsse_sim}
\alias{secsse_sim}
\title{Function to simulate a tree, conditional on observing all states.}
\usage{
secsse_sim(
  lambdas,
  mus,
  qs,
  crown_age,
  num_concealed_states,
  pool_init_states = NULL,
  max_spec = 1e+05,
  min_spec = 2,
  max_species_extant = TRUE,
  tree_size_hist = FALSE,
  conditioning = "obs_states",
  non_extinction = TRUE,
  verbose = FALSE,
  max_tries = 1e+06,
  drop_extinct = TRUE,
  seed = NULL
)
}
\arguments{
\item{lambdas}{speciation rates, in the form of a list of matrices.}

\item{mus}{extinction rates, in the form of a vector.}

\item{qs}{The Q matrix, for example the result of function q_doubletrans, but
generally in the form of a matrix.}

\item{crown_age}{crown age of the tree, tree will be simulated conditional
on non-extinction and this crown age.}

\item{num_concealed_states}{number of concealed states, generally equivalent
to the number of examined states in the dataset.}

\item{pool_init_states}{pool of initial states at the crown, in case this is
different from all available states, otherwise leave at NULL}

\item{max_spec}{Maximum number of species in the tree (please note that the
tree is not conditioned on this number, but that this is a safeguard
against generating extremely large trees).}

\item{min_spec}{Minimum number of species in the tree.}

\item{max_species_extant}{Should the maximum number of species be counted in
the reconstructed tree (if TRUE) or in the complete tree (if FALSE).}

\item{tree_size_hist}{if TRUE, returns a vector of all found tree sizes.}

\item{conditioning}{can be \code{"obs_states"}, \code{"true_states"} or \code{"none"}, the
tree is simulated until one is generated that contains all observed states
(\code{"obs_states"}), all true states (e.g. all combinations of obs and hidden
states), or is always returned (\code{"none"}). Alternatively, a vector with
the names of required observed states can be provided, e.g. c("S", "N").}

\item{non_extinction}{boolean stating if the tree should be conditioned on
non-extinction of the crown lineages. Defaults to \code{TRUE}.}

\item{verbose}{sets verbose output; default is \code{TRUE} when \code{optimmethod} is
\code{"simplex"}. If \code{optimmethod} is set to \code{"simplex"}, then even if set to
\code{FALSE}, optimizer output will be shown.}

\item{max_tries}{maximum number of simulations to try to obtain a tree.}

\item{drop_extinct}{boolean stating if extinct species should be dropped from
the tree. Defaults to \code{TRUE}.}

\item{seed}{pseudo-random number generator seed.}
}
\value{
a list with four properties: phy: reconstructed phylogeny,
true_traits: the true traits in order of tip label, obs_traits: observed
traits, ignoring hidden traits and lastly:
initialState, delineating the initial state at the root used.
}
\description{
By default, secsse_sim assumes CLA-secsse simulation, e.g.
inheritance of traits at speciation need not be symmetrical, and can be
specified through usage of lambda-matrices. Hence, the input for lambdas
is typically a list of matrices.

Simulation is performed with a randomly
sampled initial trait at the crown - if you, however - want a specific,
single, trait used at the crown, you can reduce the possible traits by
modifying \code{pool_init_states}.

By default, the algorithm keeps simulating until it generates a tree where
both crown lineages survive to the present - this is to ensure that the tree
has a crown age that matches the used crown age. You can modify
'non-extinction' to deviate from this behaviour.
}
