% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N_model.R
\name{N_model}
\alias{N_model}
\title{Analysis: graph for not significant trend}
\usage{
N_model(
  trat,
  resp,
  ylab = "Germination (\%)",
  error = "SE",
  legend = "not~signifcant",
  xlab = expression("Temperature ("^"o" * "C)"),
  theme = theme_classic(),
  width.bar = NA,
  legend.position = "top"
)
}
\arguments{
\item{trat}{Numerical vector with treatments (Declare as numeric)}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{ylab}{Dependent variable name (Accepts the \emph{expression}() function)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{legend}{Add the legend}

\item{xlab}{Independent variable name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{width.bar}{Bar width}

\item{legend.position}{Legend position (\emph{default} is "top")}
}
\value{
The function returns an exploratory graph of segments
}
\description{
Ggraph for non-significant trend. Can be used within the multicurve command
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)

#================================
# Germination
#================================
N_model(trat,germ)

#================================
# Germination speed
#================================
N_model(trat, vel, ylab=expression("v"~(dias^-1)))
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
\keyword{non-significant}
