% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_model_using_radar.R
\name{mixed_model_radar}
\alias{mixed_model_radar}
\alias{mixed_model_using_radar}
\alias{mixed_model_using_radar_with_time_correction}
\title{Mixed Model Using Instantaneous Velocity}
\usage{
mixed_model_using_radar(
  data,
  time,
  velocity,
  athlete,
  time_correction = 0,
  random = MSS + TAU ~ 1,
  LOOCV = FALSE,
  na.rm = FALSE,
  ...
)

mixed_model_using_radar_with_time_correction(
  data,
  time,
  velocity,
  athlete,
  random = MSS + TAU ~ 1,
  LOOCV = FALSE,
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{data}{Data frame}

\item{time}{Character string. Name of the column in \code{data}}

\item{velocity}{Character string. Name of the column in \code{data}}

\item{athlete}{Character string. Name of the column in \code{data}. Used as levels in the \code{\link[nlme]{nlme}}}

\item{time_correction}{Numeric vector. Used to filter out noisy data from the radar gun.
This correction is done by adding \code{time_correction} to \code{time}. Default is 0. See more in Samozino (2018)}

\item{random}{Formula forwarded to \code{\link[nlme]{nlme}} to set random effects. Default is \code{MSS + TAU ~ 1}}

\item{LOOCV}{Should Leave-one-out cross-validation be used to estimate model fit? Default is \code{FALSE}.
This can be very slow process due high level of samples in the radar data}

\item{na.rm}{Logical. Default is FALSE}

\item{...}{Forwarded to \code{\link[nlme]{nlme}} function}
}
\value{
List object with the following elements:
    \describe{
        \item{parameters}{List with two data frames: \code{fixed} and \code{random} containing the following
            estimated parameters: \code{MSS}, \code{TAU}, \code{MAC}, and \code{PMAX}}
        \item{model_fit}{List with the following components:
            \code{RSE}, \code{R_squared}, \code{minErr}, \code{maxErr}, and \code{RMSE}}
        \item{model}{Model returned by the \code{\link[nlme]{nlme}} function}
        \item{data}{Data frame used to estimate the sprint parameters, consisting of \code{athlete}, \code{time},
          \code{velocity}, and \code{pred_velocity} columns}
        }
}
\description{
This function models the sprint instantaneous velocity using mono-exponential equation and non-linear
    mixed model using \code{\link[nlme]{nlme}} to estimate fixed and random maximum sprinting speed (\code{MSS})
    and relative acceleration (\code{TAU}) parameters. In mixed model, fixed and random effects are estimated for
    \code{MSS} and \code{TAU} parameters using \code{athlete} as levels. \code{velocity} is used as target or outcome
    variable, and \code{time} as predictor.
}
\examples{
data("radar_gun_data")

mixed_model <- mixed_model_using_radar(radar_gun_data, "time", "velocity", "athlete")

print(mixed_model)
coef(mixed_model)
plot(mixed_model)

mixed_model_correction <- mixed_model_using_radar_with_time_correction(
  radar_gun_data,
  "time",
  "velocity",
  "athlete"
)

print(mixed_model_correction)
coef(mixed_model_correction)
plot(mixed_model_correction)
}
\references{
Samozino P. 2018. A Simple Method for Measuring Force, Velocity and Power Capabilities and Mechanical
        Effectiveness During Sprint Running. In: Morin J-B, Samozino P eds. Biomechanics of Training and Testing.
       Cham: Springer International Publishing, 237–267. DOI: 10.1007/978-3-319-05633-3_11.
}
