% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-cov.r
\name{cov_shrink_diag}
\alias{cov_shrink_diag}
\title{Computes a shrunken version of the maximum likelihood estimator for the
sample covariance matrix under the assumption of multivariate normality.}
\usage{
cov_shrink_diag(x, gamma = 1)
}
\arguments{
\item{x}{data matrix with \code{n} observations and \code{p} feature vectors}

\item{gamma}{the shrinkage parameter. Must be between 0 and 1, inclusively.
By default, the shrinkage parameter is 1, which simply yields the MLE.}
}
\value{
shrunken sample covariance matrix of size \eqn{p \times p}
}
\description{
For a sample matrix, \code{x}, we compute the sample covariance matrix as the
maximum likelihood estimator (MLE) of the population covariance matrix and
shrink it towards its diagonal.
}
\details{
Let \eqn{\widehat{\Sigma}} be the MLE of the covariance matrix \eqn{\Sigma}.
Then, we shrink the MLE towards its diagonal by computing
\deqn{\widehat{\Sigma}(\gamma) = \gamma \widehat{\Sigma} + (1 - \gamma)
\widehat{\Sigma} \circ I_p,} where \eqn{\circ} denotes the Hadamard product
and \eqn{\gamma \in [0,1]}.

For \eqn{\gamma < 1}, the resulting shrunken covariance matrix estimator is
positive definite, and for \eqn{\gamma = 1}, we simply have the MLE, which can
potentially be positive semidefinite (singular).

The estimator given here is based on Section 18.3.1 of the Hastie et
al. (2008) text.
}
\references{
Hastie, T., Tibshirani, R., and Friedman, J. (2008), "The
Elements of Statistical Learning: Data Mining, Inference, and Prediction,"
2nd edition. \url{http://statweb.stanford.edu/~tibs/ElemStatLearn/}
}

