% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_estimators.R
\name{rank_regression}
\alias{rank_regression}
\title{Rank Regression for Two-Parameter Lifetime Distributions}
\usage{
rank_regression(x, y, event, distribution = c("weibull", "lognormal",
  "loglogistic"), conf_level = 0.95, details = TRUE)
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{y}{a numeric vector which consists of estimated failure probabilities
regarding the lifetime data in \code{x}.}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}.
Other distributions have not been implemented yet.}

\item{conf_level}{confidence level of the interval. The default value is
\code{conf_level = 0.95}.}

\item{details}{a logical variable, where the default value is \code{TRUE}.
If \code{FALSE} the output consists of a list that only contains the
estimated parameters. If \code{TRUE} the output is a detailed list with
many more information. See below (\strong{Value}).}
}
\value{
Returns a list with the following components (depending on
  \code{details} argument):
  \itemize{
  \item \code{coefficients} : Provided, if \code{distribution} is \code{"weibull"}.
    \eqn{\eta} is the estimated scale and \eqn{\beta} the estimated shape parameter.
  \item \code{confint} : Provided, if \code{distribution} is \code{"weibull"}.
    Confidence interval for \eqn{\eta} and \eqn{\beta}.
  \item \code{loc_sc_coefficients} : Estimated location-scale parameters.
  \item \code{loc_sc_confint} : Confidence interval for location-scale parameters.
  \item \code{loc_sc_vcov} : Provided, if \code{distribution} is not
    \code{"weibull"}. Estimated heteroscedasticity-consistent
    Variance-Covariance matrix of the used location-scale distribution.
  \item \code{r_squared} : Coefficient of determination.}
}
\description{
This method fits an \strong{x on y} regression to the linearized
two-parameter cdf and is applicable for complete and (multiple) right
censored data. The parameters are estimated in the frequently used
location-scale parametrization. For the Weibull, estimates are transformed such that
they are in line with the parametrization provided by the \emph{stats} package
like \code{\link{pweibull}}.
}
\details{
When using this method, the approximated confidence intervals for the Weibull
parameters (based on p. 51 of Ralf Mock) can only be estimated for the
following confidence levels:
\itemize{
  \item \code{conf_level} = 0.90,
  \item \code{conf_level} = 0.95,
  \item \code{conf_level} = 0.99.}

If the distribution is not the Weibull, the confidence intervals of the
parameters are calculated using a heteroscedasticity-consistent covariance matrix.
Here it should be said that there is no statistical foundation to calculate the
standard errors for the parameters using \emph{Least Squares} in context of
\emph{Median Rank Regression}. For an accepted statistical method use MLE
(\code{\link{ml_estimation}}).
}
\examples{
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

df_john <- johnson_method(x = obs, event = state)
mrr <- rank_regression(x = df_john$characteristic,
                       y = df_john$prob,
                       event = df_john$status,
                       distribution = "weibull",
                       conf_level = .90)
}
\references{
Mock, R., Methoden zur Datenhandhabung in
  Zuverlässigkeitsanalysen, vdf Hochschulverlag AG an der ETH Zürich, 1995
}
