% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\encoding{UTF-8}
\name{plot_mod}
\alias{plot_mod}
\alias{plot_mod.wt_model}
\title{Add Estimated Population Line(s) to a Probability Plot}
\usage{
plot_mod(p_obj, x, ...)

\method{plot_mod}{wt_model}(p_obj, x, title_trace = "Fit", ...)
}
\arguments{
\item{p_obj}{A plot object returned from \code{\link{plot_prob}}.}

\item{x}{An object of class \code{wt_model}.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}

\item{title_trace}{A character string which is assigned to the trace shown in
the legend.}
}
\value{
Returns a plot object containing the probability plot with
  plotting positions and the estimated regression line(s).
}
\description{
This function adds one or multiple estimated regression lines to an existing
probability plot (\code{\link{plot_prob}}). Depending on the output of the
functions \code{\link{rank_regression}}, \code{ml_estimation},
\code{\link{mixmod_regression}} or \code{\link{mixmod_em}} one or
multiple lines are plotted.
}
\details{
The name of the legend entry is a combination of the \code{title_trace} and
the number of determined subgroups from \code{\link{mixmod_regression}} or
\code{\link{mixmod_em}}. If \code{title_trace = "Line"} and the
data could be split in two groups, the legend entries would be "Line: 1"
and "Line: 2".
}
\examples{
# Reliability data:
data <- reliability_data(data = alloy, x = cycles, status = status)

# Probability estimation:
prob_tbl <- estimate_cdf(data, methods = c("johnson", "kaplan"))


## Rank Regression
# Example 1 - Probability Plot and Regression Line Three-Parameter-Weibull:
plot_weibull <- plot_prob(prob_tbl, distribution = "weibull")
rr_weibull <- rank_regression(prob_tbl, distribution = "weibull3")

plot_reg_weibull <- plot_mod(p_obj = plot_weibull, x = rr_weibull)

# Example 2 - Probability Plot and Regression Line Three-Parameter-Lognormal:
plot_lognormal <- plot_prob(prob_tbl, distribution = "lognormal")
rr_lognormal <- rank_regression(prob_tbl, distribution = "lognormal3")

plot_reg_lognormal <- plot_mod(p_obj = plot_lognormal, x = rr_lognormal)


## ML Estimation
# Example 3 - Probability Plot and Regression Line Two-Parameter-Weibull:
plot_weibull <- plot_prob(prob_tbl, distribution = "weibull")
ml_weibull_2 <- ml_estimation(data, distribution = "weibull")

plot_reg_weibull_2 <- plot_mod(p_obj = plot_weibull, ml_weibull_2)


## Mixture Identification
# Reliability data:
data_mix <- reliability_data(voltage, x = hours, status = status)

# Probability estimation:
prob_mix <- estimate_cdf(
  data_mix,
  methods = c("johnson", "kaplan", "nelson")
)

# Example 4 - Probability Plot and Regression Line Mixmod Regression:
mix_mod_rr <- mixmod_regression(prob_mix, distribution = "weibull")
plot_weibull <- plot_prob(mix_mod_rr)

plot_reg_mix_mod_rr <- plot_mod(p_obj = plot_weibull, x = mix_mod_rr)

# Example 5 - Probability Plot and Regression Line Mixmod EM:
mix_mod_em <- mixmod_em(data_mix)
plot_weibull <- plot_prob(mix_mod_em)

plot_reg_mix_mod_em <- plot_mod(p_obj = plot_weibull, x = mix_mod_em)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998
}
