% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeSigMatrix.R
\name{matrixToGenelist}
\alias{matrixToGenelist}
\title{Make a GSVA genelist}
\usage{
matrixToGenelist(sigMat, gList = NULL)
}
\arguments{
\item{sigMat}{A signature matrix such as from ADAPTS::AugmentSigMatrix()}

\item{gList}{A list of prioritized genes such as from ADAPTS::gListFromRF() (DEFAULT:NULL)}
}
\value{
A list of genes for each cell types musually in sigMat and gList
}
\description{
Provide a gList and signature matrix with matched cell types to get signatures
  gene lists for GSVA and similar algorithms.
  gList=NULL select highest genes for each cell type, minimum of 3.
}
\examples{
library(ADAPTS)
ct1 <- runif(1000, 0, 100)
ct2 <- runif(1000, 0, 100)
dataMat <- cbind(ct1, ct1, ct1, ct1, ct1, ct1, ct2, ct2, ct2, ct2)
rownames(dataMat) <- make.names(rep('gene', nrow(dataMat)), unique=TRUE)
noise <- matrix(runif(nrow(dataMat)*ncol(dataMat), -2, 2), nrow = nrow(dataMat), byrow = TRUE)
dataMat <- dataMat + noise
gList <- ADAPTS::gListFromRF(trainSet=dataMat, oneCore=TRUE)
newSigMat <- ADAPTS::buildSeed(trainSet=dataMat, plotIt=FALSE)
geneLists <- matrixToGenelist(sigMat=newSigMat, gList=gList)

}
