% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMIM.r
\name{AMIM.roll}
\alias{AMIM.roll}
\title{AMIM roll}
\usage{
AMIM.roll(
  data.table,
  identity.col,
  Date.col,
  rollWindow,
  return.col,
  min.obs,
  max.lag
)
}
\arguments{
\item{data.table}{data.table with the data}

\item{identity.col}{column name of the identity intrument for example the stock ticker}

\item{Date.col}{column name of the date column with format "YYYY-mm-dd" (for example "2019-12-01")}

\item{rollWindow}{number of days to compute the AMIM}

\item{return.col}{column name of the return column}

\item{min.obs}{minimum number of observations to compute the AMIM}

\item{max.lag}{maximum number of lags to compute the MIM and then AMIM. The algorithm will select the number of lags that minimize the AIC
but the maximum number of lags is limited by this parameter. In case the AIC is zero for the zero lag then the algorithm will
estimate an AR(1) model. This is to avoid zero in the MIM and AMIM.}
}
\value{
data.table with the MIM, AMIM and the number of lags used to compute the MIM, AMIM, confidence interval (CI), and the number of lags (N).
}
\description{
This function computes the rolling window AMIM  for a given data.table
}
\examples{
library(AMIM)
library(data.table)
data <- AMIM::exampledata # load the example data
AMIM <- AMIM.roll(
  data.table = data, identity.col = "ticker", rollWindow = 60,
  Date.col = "Date", return.col = "RET", min.obs = 30, max.lag = 10
)

AMIM[, .SD[(.N - 5):(.N), ], by = ticker] # Last 5 rows of each instrument
}
