% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bland.altman.stats}
\alias{bland.altman.stats}
\title{Calculate statistics for Bland-Altman-Plot}
\usage{
bland.altman.stats(group1, group2, two = 1.96, mode = 1, conf.int = 0.95)
}
\arguments{
\item{group1}{vector of numerics to be compared to group2}

\item{group2}{vector of numerics to be compared to group1}

\item{two}{numeric defines how many standard deviations from mean are to be
computed, defaults to 1.96 as this gives proper 95 percent CI. However, in the
original publication a factor of 2 is used.}

\item{mode}{if 1 then difference group1 minus group2 is used, if 2 then
group2 minus group1 is used. Defaults to 1.}

\item{conf.int}{usefull}
}
\value{
\code{means} vector of means, i. e. data for the x axis

\code{diffs} vector of differences, i. e. data for the y axis

\code{groups} data.frame containing pairwise complete cases of group1 and
group2. NAs are removed.

\code{based.on} count of pairwise complete cases in groups

\code{lower.limit} lower limit for BA plot

\code{mean.diffs} mean of differences, also called 'bias'

\code{upper.limit} upper limit for BA plot

\code{lines} vector containing y values where to draw horizontal
lines, i. e. mean of differences minus "two" standard deviations, mean of
differences and mean of differences plus "two" standard deviations (i. e.
\code{c(lower.limit, mean.diffs, upper.limit}). This is convenient for
printing.

\code{CI.lines} vector of confidence intervalls for the values of
lines (based on the assumption of normal distribution of differences
\code{diffs}).

\code{two} the argument 'two'

\code{critical.diff} critical difference, i. e. 'two' times standard
deviation of differences, equals half the difference of lower.limit and
upper.limit
}
\description{
Does the computation for Bland Altman plots. This will usually be called from
graphic functions like \code{bland.altman.plot} but will be usefull for
customized plot (see examples for color coded BA plot). Offers symmetric
confidence intervalls for bias and upper and lower limits.
}
\examples{
# simple calculation of stats:
a <- rnorm(20)
b <- jitter(a)
print(bland.altman.stats(a, b))
print(bland.altman.stats(a, b)$critical.diff)

# drawing Bland-Altman-Plot with color coding sex:
example.data <- data.frame(sex = gl(2,6,labels=c("f","m")),
                 m1 = c(16,10,14,18,16,15,18,19,14,11,11,17),
                 m2 = c(18, 9,15,19,19,13,19,20,14,11,13,17))
ba <- bland.altman.stats(example.data$m1, example.data$m2)
plot(ba$means, ba$diffs, col=example.data$sex, ylim=c(-4,4))
abline(h=ba$lines, lty=2)

# compute 95\%-CIs for the bias and upper and lower limits of PEFR data as
# in Bland&Altman 1986
bland.altman.stats(bland.altman.PEFR[,1],bland.altman.PEFR[,3])$CI.lines
# apparently wrong results? CAVE: Bland&Altman are using two=2, thus
bland.altman.stats(bland.altman.PEFR[,1],bland.altman.PEFR[,3], two=2)$CI.lines
}
\author{
Bernhard Lehnert <bernhard.lehnert@uni-greifswald.de>
}
\seealso{
\code{\link{bland.altman.plot}}
}

