\name{CryptRndTest-package}
\alias{CryptRndTest-package}
\alias{CryptRndTest}
\docType{package}
\title{
Statistical Tests for Cryptographic Randomness
}
\description{
Performs cryptographic randomness tests on a sequence of random integers or bits. Included tests are greatest common divisor, birthday spacings, book stack, adaptive chi-square, topological binary, and three random walk tests. Tests except greatest common divisor and birthday spacings are not covered by standard test suites. In addition to the chi-square goodness-of-fit test, results of Anderson-Darling, Kolmogorov-Smirnov, and Jarque-Bera tests are also generated by some of the cryptographic randomness tests. Additionally, it includes functions for the calculation of greatest common divisor, the Stirling numbers of the second kind, critical value of the topological binary test, and base conversions from base 2 to 10 and vice versa.
}
\details{
\tabular{ll}{
Package: \tab CryptRndTest\cr
Type: \tab Package\cr
Version: \tab 1.2.1\cr
Date: \tab 2015-12-24\cr
License: \tab GPL-3\cr
}
To test statistical randomness of cryptographic randomness use functions \code{birthday.spacings} and \code{GCD.test} for testing sequences of integers, functions \code{adaptive.chi.square} and \code{book.stack} for testing sequences of integers or bits, and use functions \code{random.walk.tests} and \code{topological.binary} for testing sequences of bits. The function \code{random.walk.tests} performs random walk-excursion, random walk-expansion, and random walk-height tests.

Additionally, use the function \code{GCD.q} to compute greatest common divisor (GCD), the number of iterations required to find GCD, and the sequence of partial quotients for two integers. Use the function \code{GCD} to compute GCD and the number iterations required to find GCD, recursively. Use the function \code{GCD.big} to compute GCD, the number iterations required to find GCD, and the sequence of partial quotients for two big integers. Use the function \code{Strlng2} to compute the Stirling numbers of the second kind in an approximate manner when the inputs are large. Use the function \code{TBT.criticalValue} to compute the critical value for the topological binary test at a given level of significance. Use the function \code{toBaseTwo} to convert integers (including big integers) from base 10 to 2. Use the function \code{toBaseTen} to convert binary sequences (including long binary sequences) from base 2 to 10.
}
\author{
Haydar Demirhan

Maintainer: Haydar Demirhan <haydarde@hacettepe.edu.tr>
}
\note{\bold{Acknowledgement:} The package \pkg{CryptRndTest} is based upon work supported by The Scientific and Technological Research Council of Turkey (TUBITAK) under Grant No. 114F249 of ARDEB-3001 grant.
}
\references{

Alcover, P.M., Guillamon, A., Ruiz, M.C., A new randomness test for bit sequences. Informatica  (2013), 24(3), 339--356.  

Bleick, W.W., Wang, P.C.C., Asymptotics of Stirling Numbers of the Second Kind. Proceedings of the American Mathematical Society (1974), 42(2), 575--580.

Doganaksoy, A., Calik, C., Sulak, F., Turan, M.S., New randomness tests using random walk, In: National Cryptology Symposium II, (2006), Ankara, Turkey.

Marsaglia, G., Tsang, W.W., Some Difficult-to-pass tests of randomness. Journal of Statistical Software (2002), 7(3).

Ryabko, B.Ya., Monarev, V.A., Using information theory approach to randomness testing. Journal of Statistical Planning and Inference (2005), 133, 95--110.

Ryabko, B.Ya., Stognienko, V.S., Shokin Yu.I., A new test for randomness and its application to some cryptographic problems. Journal of Statistical Planning and Inference (2004), 123, 365--376.

Temme, N.M., Asymptotic estimates of Stirling numbers. Studies in Applied Mathematics (1993), 89, 233--243.
}

\keyword{ Anderson-Darling, chi-Square, goodness-of-fit test, greatest common divisor, Stirling numbers of the second kind, Jarque-Bera, Kolmogorov-Smirnov, nonparametric,  randomness test}

\seealso{
\code{\link[CryptRndTest]{adaptive.chi.square}}, \code{\link[CryptRndTest]{birthday.spacings}}, \code{\link[CryptRndTest]{book.stack}}, \code{\link[CryptRndTest]{GCD.test}}, \code{\link[CryptRndTest]{GCD}}, \code{\link[CryptRndTest]{GCD.q}}, \code{\link[CryptRndTest]{GCD.big}}, \code{\link[CryptRndTest]{random.walk.tests}}, \code{\link[CryptRndTest]{topological.binary}}, \code{\link[CryptRndTest]{Strlng2}}, \code{\link[copula]{Stirling2}}
}
\examples{
# ----- General settings ---
RNGkind(kind = "Super-Duper")
B=8                  # Bit length is 8.
k=2000               # Generate 20000 integers.
alpha=0.05

# ----- Adaptive chi-square -----
A=0
A=round(runif(k,0,(2^B-1)))
S=2                 # Divide alphabet to two sub-sets.
test1=adaptive.chi.square(x=A, B, S, alpha, bit = FALSE)
print(test1)

# ----- Birthday Spacings -----
m=16                  # Number of birthdays is 16.
n=2^B                 # Length of year is 256.
lambda=(m^3)/(4*n)     
x=round(runif(k,0,(2^B-1)))
test2=birthday.spacings(x, m, n, alpha, lambda, num.class=10)
print(test2)

# ----- Book Stack -----
n=B*(2^(B/2))         # Number of required bits.
N=n/B                 # Number of integers to be generated.
A=0
A=round(runif(N,0,(2^B-1)))
K=2                   # Divide alphabet to two sub-sets.
test3=book.stack(x=A, B, k = K, alpha, bit = FALSE)
print(test3)

# ----- Toplogical Binary Test -----

dat=round(runif(k,0,(2^B-1)))
x=sfsmisc::digitsBase(dat, base= 2, B) #Convert to base 2
critical.value=150                     #Obtained for B=8
test4=topological.binary(x, B, alpha, critical.value)
print(test4)

# ----- Other Functions -----
# ----- GCD -----
result=GCD(45,2)
print(result)

result=GCD(321235,25521)
print(result)

# ----- Striling 2 -----
Strlng2(1500,410,log=TRUE)  # Large values of n and k
}