% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAMCrsa.R
\name{SAMCrsa}
\alias{SAMCrsa}
\title{A Resampling-based Stochastic Approximation Method for Analysis of Large Geostatitical data}
\usage{
SAMCrsa(coords, y, X = NULL, nsubset = max(ceiling(length(y)/5), 10),
  stepscale = 200, niter = 2500, warm = 100)
}
\arguments{
\item{coords}{an \eqn{(n\times 2)} matrix. 2D location coordinates.}

\item{y}{a length-\eqn{n} vector of response value.}

\item{X}{an \eqn{(n\times k)} matrix of extra covariates.}

\item{nsubset}{the size of the subset drawn from the data. It is recommended to be set to 300 or higher.}

\item{stepscale}{gain factor control. It specifies the number of iterations when the gain factor begins to shrink. For example, one can be set it equal to 2 times the burn-in steps.}

\item{niter}{the total number of iterations for stochastic approximation. In practice, it is recommended to be set to 2500 or higher.}

\item{warm}{the number of burn-in iterations}
}
\value{
a named list containing \describe{
\item{beta}{the coefficient estimates of the mean effect. It is a vector of length equal to the number of coefficients plus 1.}
\item{phi}{the shape estimate in the powered exponential correlation matrix.}
\item{sigmasq}{the estimate of error variance.}
\item{tausq}{the estimate of nugget variance.}
}
}
\description{
Performs parameter estimation using a resampling-based Stochastic Approximation (RSA) method. 
It is a stochatic approximation method. At every iteration, only a subset of the data is drawn and used to update the estimation of the parameters. 
The data are assumed to have a powered exponential correlation structure.
}
\examples{
##### load example data pre-loaded
data(gdata)

##### run RSA
output = SAMCrsa(gdata$coords, gdata$y, gdata$X, nsubset=50, stepscale=40, niter=100, warm=20)

}
\references{
\insertRef{SAMCrsa}{SAMCpack}
}
\author{
Yichen Cheng, Faming Liang, Kisung You
}
