% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qGH2z.R
\name{qGH2z}
\alias{qGH2z}
\title{Inverse of Tukey \eqn{g}-&-\eqn{h} Transformation}
\usage{
qGH2z(q, q0 = (q - A)/B, A = 0, B = 1, ...)
}
\arguments{
\item{q}{\link[base]{double} \link[base]{vector}, quantiles \eqn{q}}

\item{q0}{\link[base]{double} \link[base]{vector}, \eqn{q_0=(q-A)/B}, for internal use to increase compute speed}

\item{A, B}{..}

\item{...}{..}
}
\value{
Function \link{qGH2z} returns ..
}
\description{
..
}
\details{
Unfortunately, function \link{qGH2z}, the inverse of Tukey \eqn{g}-&-\eqn{h} transformation,
does not have a closed form and needs to be solved numerically.

For compute intensive jobs, use function \link{.qGH2z}.
}
\examples{
z = rnorm(1e3L)
all.equal.numeric(.qGH2z(z2qGH(z, g = .3, h = .1), g = .3, h = .1), z)
all.equal.numeric(.qGH2z(z2qGH(z, g = 0, h = .1), g = 0, h = .1), z)
all.equal.numeric(.qGH2z(z2qGH(z, g = .2, h = 0), g = .2, h = 0), z)

}
