% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReasonCodes.R
\name{RequestReasonCodes}
\alias{RequestReasonCodes}
\title{Request reason codes computation for a specified model and dataset (deprecated).}
\usage{
RequestReasonCodes(model, datasetId, maxCodes = NULL,
  thresholdLow = NULL, thresholdHigh = NULL)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{datasetId}{Character string. Id of the prediction dataset for which reason codes are
requested}

\item{maxCodes}{integer (optional) The maximum number of reason codes to supply per row of the
dataset, default: 3.}

\item{thresholdLow}{numeric (optional) The lower threshold, below which a prediction must score
in order for reason codes to be computed for a row in the dataset. If neither
\code{threshold_high} nor \code{threshold_low} is specified, reason codes will be computed
for all rows.}

\item{thresholdHigh}{numeric (optional) The high threshold, above which a prediction must score
in order for reason codes to be computed. If neither \code{threshold_high} nor
\code{threshold_low} is specified, reason codes will be computed for all rows.}
}
\value{
job Id
}
\description{
Use \link{RequestPredictionExplanations} instead.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  datasets <- ListPredictionDatasets(projectId)
  dataset <- datasets[[1]]
  datasetId <- dataset$id
  model <- GetModel(model, datasetId)
  RequestReasonCodes(model, datasetId)
}
}
