% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fetch.r
\name{fetch}
\alias{fetch}
\alias{fetch_conf}
\alias{fetch_pipes}
\title{A generic functions to search for files}
\usage{
fetch(x, places, urls, verbose = FALSE)

fetch_pipes(x, places, last_only = FALSE,
  urls = get_opts("flowr_pipe_urls"), silent = FALSE, ask = TRUE)

fetch_conf(x = "flowr.conf", places, ...)
}
\arguments{
\item{x}{name of the file to search for}

\item{places}{places (paths) to look for it. Its best to use the defaults}

\item{urls}{urls to look for, works well for pipelines.}

\item{verbose}{be chatty?}

\item{last_only}{[fetch_pipes only]. If multiple pipelines match the pattern, return the last one.}

\item{silent}{[fetch_pipes() only]. logical, be silent even if no such pipeline is available.}

\item{ask}{ask before downloading or copying, not used !}

\item{...}{not used}
}
\description{
These functions help in searching for specific files in the user's space.

fetch_pipes(): Fetches pipelines in the following places,
\itemize{
\item - available in 'pipelines' folders in flowr and ngsflows packages.
\item - ~/flowr/pipelines
\item - github repos (currently not supported)
}

fetch_conf(): Fetches configuration files in the following places,

\itemize{
\item - available in 'conf' folders in flowr and ngsflows packages.
\item - ~/flowr/conf folder
}

By default flowr loads, ~/flowr/conf/flowr.conf and ~/flowr/conf/ngsflows.conf
}
\examples{
{
fetch_conf("torque.sh")
}
}

