% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbose.R
\docType{data}
\name{verbose}
\alias{verbose}
\title{Verbose levels, defining verboseness of messages}
\format{An object of class \code{NULL} of length 0.}
\usage{
verbose
}
\description{
There are several levels of verboseness one can choose from.

\strong{levels:}

\itemize{
	\item level 0 is almost silent, producing only necessary messages 
	\item level 1 is good for most purposes, where as, 
	\item level 2 is good when developing a new pipeline.
	\item level 3 is good for debugging, especially when getting un-expected results.
}
	
	One can set the level of verboseness using \code{opts_flow$set(verbose=2)}, which 
	will be used across flowr and ngsflows packages. Additionally one may set this value in 
	the configurations files: \code{~/flowr/conf/flowr.conf} OR \code{~/flowr/conf/ngsflows.conf}.
}
\examples{
fl = system.file("pipelines/abcd.def", package = "flowr")
def = as.flowdef(fl, verbose = 0)
# def seems to be a file, reading it...
def = as.flowdef(fl, verbose = 1)
# def seems to be a file, reading it...
# checking if required columns are present...
# checking if resources columns are present...
# checking if dependency column has valid names...
# checking if submission column has valid names...
# checking for missing rows in def...
# checking for extra rows in def...
# checking submission and dependency types...
def = as.flowdef(fl, verbose = 2)
# def seems to be a file, reading it...
# checking if required columns are present...
# checking if resources columns are present...
# checking if dependency column has valid names...
# checking if submission column has valid names...
# checking for missing rows in def...
# checking for extra rows in def...
# checking submission and dependency types...
# jobname	prev.sub_type --> dep_type --> sub_type: relationship
# 	1: A	none --> none --> scatter 
# 	2: B	scatter --> serial --> scatter rel: complex one:one
# 	3: C	scatter --> gather --> serial rel: many:one
# 	4: D	serial --> burst --> scatter rel: one:many
}
\keyword{datasets}

